/* Rozdzia 3. Polecenie touch. */
/* Zmodyfikowany 2 wrzenia 2005, aby naprawi dziaanie opcji -a i -m. */
/* touch[opcje] pliki
	Aktualizuje czas dostpu do pliku i jego modyfikacji.
	Tworzy nieistniejce pliki.
	Opcje:
		-a aktualizuje tylko czas dostpu.
		-m aktualizuje tylko czas ostatniego zapisu.
		         Mona jednak uy obu tych opcji, dlatego okrelenie "tylko" jest nieprecyzyjne.
		-c nie naley tworzy nieistniejcych plikw. */

/* Ten program ilustruje:
	1. Ustawianie atrybutw pliku zwizanych z czasem.
	2. Przeksztacanie z czasu systemowego na czas zwizany z plikami. */

#include "Everything.h"

int _tmain (int argc, LPTSTR argv[])
{
	FILETIME newFileTime;
	LPFILETIME pAccessTime = NULL, pModifyTime = NULL;
	HANDLE hFile;
	BOOL setAccessTime, setModTime, notCreateNew, maFlag;
	DWORD CreateFlag;
	int i, FileIndex;

	/* Okrelanie opcji. */

	if (argc < 2) {
		_tprintf(_T("Stosowanie: touch[opcje] pliki"));
		return 1;
	}
	FileIndex = Options(argc, argv, _T ("amc"),
			&setAccessTime, &setModTime, &notCreateNew, NULL);

	/* Okrelanie, czy naley zmodyfikowa jeden czas czy dwa. */
	maFlag = setAccessTime || setModTime;
	CreateFlag = notCreateNew ? OPEN_EXISTING : OPEN_ALWAYS;

	for (i = FileIndex; i < argc; i++) {
		hFile = CreateFile(argv[i], GENERIC_READ | GENERIC_WRITE, 0, NULL,
				CreateFlag, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hFile == INVALID_HANDLE_VALUE) {
			if (!notCreateNew) ReportError (_T ("Blad programu touch: nie mozna otworzyc pliku."), 0, TRUE);
			continue;
		}
		/* Pobieranie biecego czasu systemowego i przeksztacanie go na czas dla pliku.
			Nie naley zmienia czasu utworzenia. */
		GetSystemTimeAsFileTime(&newFileTime);
		if (setAccessTime || !maFlag) pAccessTime = &newFileTime;
		if (setModTime || !maFlag) pModifyTime = &newFileTime;
		if (!SetFileTime(hFile, NULL, pAccessTime, pModifyTime))
			ReportError(_T ("Nieudane ustawianie czasu pliku."), 2, TRUE);
		CloseHandle(hFile);
	}
	return 0;
}
