/* Rozdzia 3. Polecenie tail. */
/* tail plik - wywietla 10 ostatnich wierszy z pliku nazwanego.
	Wszystkie opcje s ignorowane. Trzeba poda plik. */

/* Ten program ilustruje:
	1. Pobieranie rozmiaru pliku.
	2. Ustawianie wskanika pliku.
	3. Arytmetyk na wartociach typu LARGE_INTEGER i uywanie 64-bitowych pozycji plikw.
	4. Pobieranie biecej pozycji pliku przez przesunicie o
		0 bajtw wzgldem biecej pozycji. */

/*  AKTUALIZACJE. 12 kwietnia 2010. 
 *  1. Program uywa funkcji GetFileSizeEx i SetFilePointerEx. S one duo atwiejsze w uyciu ni wersje standardowe i 
       s obsugiwane we wszystkich docelowych systemach Windows.
 *  2. Wprowadzono kilka poprawek zasugerowanych przez Kwan Ting Chana, aby uwzgldni rozmiar wiersza i kodowanie UNICODE.
 *
 *  OGRANICZENIA: wiersze nie powinny by dusze ni 256 znakw.
 *  Zaoono, a plik ma kodowanie UNICODE. Program nie 
 *  prbuje wykry typu plikw (zostawiam to jako wiczenie dla Czytelnika).
 */
#include "Everything.h"

#define NUM_LINES 11
	/* O jeden wicej ni liczba wierszy na kocu pliku. */
#define MAX_LINE_SIZE 256
#define MAX_CHAR NUM_LINES*(MAX_LINE_SIZE+1)

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hInFile;
	HANDLE hStdOut = GetStdHandle (STD_OUTPUT_HANDLE);
	LARGE_INTEGER FileSize, CurPtr, FPos;
	LARGE_INTEGER LinePos[NUM_LINES];
	DWORD LastLine, FirstLine, LineCount, nRead;
	TCHAR buffer[MAX_CHAR + 1], c;

	if (argc != 2)
		ReportError (_T("Stosowanie: tail plik"), 1, FALSE);
	hInFile = CreateFile (argv [1], GENERIC_READ,
			0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hInFile == INVALID_HANDLE_VALUE)
		ReportError (_T("Blad programu tail: nie mozna otworzyc pliku."), 2, TRUE);

	/* Pobieranie obecnej dugoci pliku. */
	if (!GetFileSizeEx (hInFile, &FileSize))
		ReportError (_T("Blad programu tail: okreslanie rozmiaru pliku."), 3, TRUE);

	/* Ustawianie wskanika pliku przy zaoeniu, e 256
		to maksymalny rozmiar, i z uwzgldnieniem pocztku wiersza.
		Jeli nie mona znale 10 wierszy, uwzgldniane s tylko
		te znalezione. W oglniejszym rozwizaniu naley 
		cofn si jeszcze bardziej w pliku. Inna moliwo
		to rozpoczcie skanowania na pocztku pliku, jednak w 
		duych plikach moe to by czasochonne. */

	CurPtr.QuadPart = (LONGLONG)FileSize.QuadPart
			- NUM_LINES * MAX_LINE_SIZE * sizeof (TCHAR);
	if (CurPtr.QuadPart < 0) CurPtr.QuadPart = 0;
	if (!SetFilePointerEx (hInFile, CurPtr, &FPos, FILE_BEGIN))
		ReportError (_T("Blad programu tail: ustawianie wskaznika."), 4, TRUE);

	/*  Skanowanie pliku pod ktem pocztku wiersza i zachowywanie
		pozycji. Zakadamy, e pocztek wiersza znajduje si na bieacej pozycji. */

	LinePos [0].QuadPart = CurPtr.QuadPart;
	LineCount = 1;
	LastLine = 1;
	while (TRUE) {
		while (ReadFile (hInFile, &c, sizeof(TCHAR), &nRead, NULL)
				&& nRead > 0 && c != CR) ; /* Puste ciao ptli. */
		if (nRead < sizeof(TCHAR)) break;
					/* Znaleziono symbol CR. Czy nastpny znak to LF? */
		ReadFile (hInFile, &c, sizeof(TCHAR), &nRead, NULL);
		if (nRead < sizeof(TCHAR)) break;
		if (c != LF) continue;
		CurPtr.QuadPart = 0;
		/* Pobieranie biecej pozycji pliku. */
		if (!SetFilePointerEx (hInFile, CurPtr, &CurPtr, FILE_CURRENT))
			ReportError (_T("Blad programu tail: ustawianie wskaznika na biezaca pozycje."), 5, TRUE);
				/* Zachowywanie pozycji na pocztku wiersza. */
		LinePos[LastLine].QuadPart = CurPtr.QuadPart;
		LineCount++;
		LastLine = LineCount % NUM_LINES;
	}
	
	FirstLine = LastLine % NUM_LINES;
	if (LineCount < NUM_LINES) FirstLine = 0;
	CurPtr.QuadPart = LinePos[FirstLine].QuadPart;

	/* Pocztek kadego wiersza jest przechowywany w tablicy LinePos [],
		a indeks ostatniego wiersza to LastLine.
		Wywietlanie ostatnich acuchw znakw. */

	if (!SetFilePointerEx (hInFile, CurPtr, NULL, FILE_BEGIN))
		ReportError (_T("Blad programu tail: ustawianie wskaznika na pozycje nowego wiersza."), 6, TRUE);

	ReadFile (hInFile, buffer, MAX_CHAR * sizeof(TCHAR), &nRead, NULL);
	buffer [nRead/sizeof(TCHAR)] = _T('\0');
	PrintMsg (hStdOut, buffer);
	CloseHandle (hInFile);
	return 0;
}
