// Rozdzia 3.
// RecordAccessTestDataGenerate.cpp : generowanie losowych danych w celu przetestowania wydajnoci.
//    RecordAccess   (Rozdzia 3.)      dostp bezporedni do pliku
//    RecordAccessMM (Rozdzia 5.)      pliki odwzorowane w pamici
// Generuje polecenia dla programu w celu odczytu lub zapisu rekordw.

#include "Everything.h"
//#include <WINIOCTL.H>

#define STRING_SIZE 256
typedef struct _RECORD { /* Struktura rekordw pliku. */
	DWORD			ReferenceCount;  /* 0 oznacza pusty rekord. */
	SYSTEMTIME		RecordCreationTime;
	SYSTEMTIME		RecordLastRefernceTime;
	SYSTEMTIME		RecordUpdateTime;
	TCHAR			DataString[STRING_SIZE];
} RECORD;
typedef struct _HEADER { /* Nagwek pliku. */
	DWORD			NumRecords;
	DWORD			NumNonEmptyRecords;
} HEADER;

#define STRING_SIZE 256

int rimes_rand (unsigned int, unsigned int);
void rand_string (char *, unsigned int);

int main(unsigned int argc, char * argv[])
{
	char cdata[STRING_SIZE];
	unsigned int filesize = atoi(argv[2]);
    unsigned int ndata = atoi(argv[1]);

	cdata[STRING_SIZE-1] = 0;

	if (argc < 5) {
		printf ("Stosowanie: RecordAccessData dane rozmiarpliku plik polecenie(w|z).\n");
		return 1;
	}
	FILE * file;
	
	if (0 != fopen_s (&file, argv[3], "z")) {
		printf ("Plik wyjsciowy: %s, nieudane tworzenie.\n", argv[3]);
		return 2;
	}
	for (int i = 0; i < atoi(argv[1]); ++i) {
		unsigned int irec = rimes_rand(rand()*i*i, filesize);
		if (argv[4][0] == 'z') {
            fprintf (file, "z %d\n", irec);
            rand_string (cdata, STRING_SIZE-1);
		    fprintf (file, "%s\n", cdata);
		} else {
			irec = (irec+1) % filesize;
            fprintf (file, "w %d\n", irec);
		}

	}
	fprintf (file, "ko\n");

	fclose (file);
	return 0;
}

// Generator liczb pseudolosowych oparty na funkcji rimes.
// To zbyt zgrubne rozwizanie - potrzebny jest klucz wielobajtowy.
int rimes_rand(unsigned int iseed, unsigned int size)
{
    unsigned int hash = ~0u;
	char ascii[10];
	_itoa_s (iseed, ascii, 16);
    for (int i = 0; i < sizeof(ascii) && ascii[i] != 0; i++) hash = hash * 33 + ascii[i];
    return (size > 0) ? hash % size : hash;
}

static char characters[] = "abcdefghijklmnopqrstuvwxyzABCEFGHIJKLMNOPQURSTUVWXYS1234567890";
void rand_string (char *cdata, unsigned int size)
{
	size_t len = strlen (characters);
	for (unsigned int i = 0; i < size; ++i) {
		size_t cn = rand() % len;
        cdata[i] = characters[cn];
	}
    
	return;
}