	/*	Rozdzia 3. RecordAccess. */
	//
	/*	Demonstruje proste zarzdzanie rekordami w pliku.
		Plik to kolekcja dowolnej liczby rekordw (jest ona okrelana
		w wierszu polece. Kady rekord obejmuje acuch znakw (o ograniczonej dugoci),
		czas utworzenia, czas ostatniej aktualizacji i liczb aktualizacji.
		Plik posiada 8-bajtowy NAGWEK z czn liczb 
		miejsc na rekordy i liczb niepustych rekordw.
		Uytkownik moe w interaktywny sposb tworzy, aktualizowa i modyfikowa
		rekordy.

		Stosowanie: RecordAccessMM NazwaPliku[liczbaRekordw[prompt]]
		Jeli nie podano parametru liczbaRekordw, plik NazwaPliku musi ju istnie. 
		Jeeli liczbaRekordw > 0, plik NazwaPliku jest odtwarzany (istniejcy plik zostaje usunity),
		   a program koczy dziaanie po utworzeniu pustego pliku.
		Jeli okrelony jest parametr prompt, interakcja z uytkownikiem jest blokowana. Jest to przydatne, jeli
		   polecenia wejciowe s przekierowywane z pliku, jak ma to miejsce w testach wydajnoci
		  [na przykad w pliku RecordAccessTIME.bat].

		Jeli liczba rekordw jest dua, zalecany jest plik rzadki.
		Uyte tu techniki mona te wykorzysta, jeli do okrelania lokalizacji 
		rekordu suy funkcja haszujca (jest to proste wzbogacenie programu). */

	/* Ten program ilustruje:
		1. Bezporedni dostp do pliku.
		2. Arytmetyk na wartociach typu LARGE_INTEGER i stosowanie 64-bitowych pozycji w pliku. 
		3. Aktualizowanie rekordw w miejscu.
		4. Inicjowanie pliku wartoci 0 (nie zadziaa w systemach Windows 9x
			ani w systemie plikw FAT). 
	*/

	#include "Everything.h"

	#define STRING_SIZE 256
	typedef struct _RECORD { /* Struktura rekordw pliku. */
		DWORD			referenceCount;  /* 0 oznacza pusty rekord. */
		SYSTEMTIME		recordCreationTime;
		SYSTEMTIME		recordLastRefernceTime;
		SYSTEMTIME		recordUpdateTime;
		TCHAR			dataString[STRING_SIZE];
	} RECORD;
	typedef struct _HEADER { /* Nagwek pliku. */
		DWORD			numRecords;
		DWORD			numNonEmptyRecords;
	} HEADER;

	int _tmain (int argc, LPTSTR argv[])
	{
		HANDLE hFile;
		LARGE_INTEGER currentPtr;
		DWORD OpenOption, nXfer, recNo;
		RECORD record;
		TCHAR string[STRING_SIZE], command, extra;
		OVERLAPPED ov = {0, 0, 0, 0, NULL}, ovZero = {0, 0, 0, 0, NULL};
		HEADER header = {0, 0}; 
		SYSTEMTIME currentTime;
		BOOLEAN headerChange, recordChange;
		int prompt = (argc <= 3) ? 1 : 0;

 		if (argc < 2)
			ReportError (_T("Stosowanie: RecordAccess plik [liczbaRekordow [prompt]]"), 1, FALSE);

		OpenOption = ((argc > 2 && _ttoi(argv[2]) <= 0) || argc <= 2) ? OPEN_EXISTING : CREATE_ALWAYS;
		hFile = CreateFile (argv[1], GENERIC_READ | GENERIC_WRITE,
			0, NULL, OpenOption, FILE_FLAG_RANDOM_ACCESS, NULL);
		if (hFile == INVALID_HANDLE_VALUE)
			ReportError (_T("Blad programu RecordAccess: nie mozna otworzyc istniejacego pliku."), 2, TRUE);

		if (argc >= 3 && _ttoi(argv[2]) > 0)  { /* Zapis nagwka. */
	#if 0
	/* Po pierwsze, jeli to moliwe, naley utworzy plik rzadki - jest to zalecane dla duych plikw. */
	/*      Zadanie - spraw, aby rozwizanie to dziaao poprawnie. Moesz te utworzy plik rzadki */
	/*		metodami administracyjnymi. Ten kod pochodzi z kilku przykadw Microsoftu i */
	/*      nie dziaa w systemie XP Home Edition (nie obsuguje on plikw rzadkich). */

			if (!GetVolumeInformation (_T("C:\\"), NULL, 0, NULL, NULL, &fsFlags , NULL, 0))
				ReportError (_T("Blad programu RecordAccess: funkcja GetVolumeInformation."), 3, TRUE);
			if (fsFlags & FILE_SUPPORTS_SPARSE_FILES) {
				if ((fsFlags & FILE_SUPPORTS_SPARSE_FILES) &&
					!DeviceIoControl (hFile, FSCTL_SET_SPARSE, NULL, 0, NULL, 0, &nXfer, NULL)) 
					ReportError (_T("Blad programu RecordAccess: tworzenie nowego rzadkiego pliku."), 0, TRUE);
			} 
			_tprintf (_T("Czy plik jest rzadki? %x\n"), 
				GetFileAttributes(argv[1]) & FILE_ATTRIBUTE_SPARSE_FILE);
	#endif
			header.numRecords = _ttoi(argv[2]);
			if (!WriteFile(hFile, &header, sizeof (header), &nXfer, &ovZero))
				ReportError (_T("Blad programu RecordAccess: zapis naglowka."), 4, TRUE);
			
			currentPtr.QuadPart = (LONGLONG)sizeof(RECORD) * _ttoi(argv[2]) + sizeof(HEADER);
			if (!SetFilePointerEx (hFile, currentPtr, NULL, FILE_BEGIN))
				ReportError (_T("Blad programu RecordAccess: ustawianie wskaznika."), 4, TRUE);
			if (!SetEndOfFile(hFile))
				ReportError (_T("Blad programu RecordAccess: ustawianie konca pliku."), 5, TRUE);
			if (prompt) _tprintf (_T("Utworzono pusty plik na %d rekordow.\n"), header.numRecords);
			return 0;
		}

		/* Odczyt nagwka w celu okrelenia liczby rekordw i liczby niepustych rekordw. */
		if (!ReadFile(hFile, &header, sizeof (HEADER), &nXfer, &ovZero))
			ReportError (_T("Blad programu RecordAccess: odczyt naglowka."), 6, TRUE);
		if (prompt) _tprintf (_T("Plik %s zawiera %d niepustych rekordow o rozmiarze %d.\n Laczna pojemnosc: %d\n"),
			argv[1], header.numNonEmptyRecords, sizeof(RECORD), header.numRecords);

		/* Pytanie uytkownika o odczyt lub zapis rekordu o danym numerze. */
		while (TRUE) {
			headerChange = FALSE; recordChange = FALSE;
			if (prompt) _tprintf (_T("Wpisz: w(czytaj)/z(apisz)/u(sun)/ko(niec) numer rekordu\n"));
			_tscanf (_T("%c%u%c"), &command, &recNo, &extra);
			if (command == _T('k')) break;
			if (recNo >= header.numRecords) { 
				if (prompt) _tprintf (_T("Numer rekordu jest za duzy. Sprobuj ponownie.\n"));
				continue;
			}
			currentPtr.QuadPart = (LONGLONG)recNo * sizeof(RECORD) + sizeof(HEADER);
			ov.Offset = currentPtr.LowPart;
			ov.OffsetHigh = currentPtr.HighPart;
			if (!ReadFile (hFile, &record, sizeof (RECORD), &nXfer, &ov))
				ReportError (_T("Program RecordAccess: blad funkcji ReadFile."), 7, FALSE);
			GetSystemTime (&currentTime); /* Suy do aktualizowania pl z czasami z rekordu. */
			record.recordLastRefernceTime = currentTime;
			if (command == _T('w') || command == _T('u')) { /* Informowanie o zawartoci rekordu (jeli taka istnieje). */
				if (record.referenceCount == 0) {
					if (prompt) _tprintf (_T("Rekord numer %d jest pusty.\n"), recNo);
					continue;
				} else {
					if (prompt) _tprintf (_T("Rekord numer %d. Liczba odwolan: %d \n"), 
						recNo, record.referenceCount);
					if (prompt) _tprintf (_T("Dane: %s\n"), record.dataString);
					/* wiczenie: dodaj wywietlanie czasu. Jako przykad zobacz program ls.c. */
				}
				if (command == _T('u')) { /* Usuwanie rekordu. */
					record.referenceCount = 0;
					header.numNonEmptyRecords--;
					headerChange = TRUE;
					recordChange = TRUE;
				}
			} else if (command == _T('z')) { /* Zapis rekordu (take za pierwszym razem). */
				if (prompt) _tprintf (_T("Wpisz nowy lancuch danych dla rekordu.\n"));
				_fgetts (string, sizeof(string), stdin); // Nie naley uywa _getts (grozi przepenieniem bufora).
				string[_tcslen(string)-1] = _T('\0'); // Usuwanie znaku nowego wiersza.
				if (record.referenceCount == 0) {
					record.recordCreationTime = currentTime;
					header.numNonEmptyRecords++;
					headerChange = TRUE;
				}
				record.recordUpdateTime = currentTime;
				record.referenceCount++;
				_tcsncpy (record.dataString, string, STRING_SIZE-1);
				recordChange = TRUE;
			} else {
				if (prompt) _tprintf (_T("Polecenia to w, z i u. Sprobuj ponownie.\n"));
			}
			/* Aktualizowanie rekordu "w miejscu" przy zmianie jego zawartoci. */
			if (recordChange && !WriteFile (hFile, &record, sizeof (RECORD), &nXfer, &ov))
				ReportError (_T("Program RecordAccess: blad aktualizacji w funkcji WriteFile."), 8, FALSE);
			/* Aktualizowanie w razie potrzeby liczby niepustych rekordw. */
			if (headerChange) {
				if (!WriteFile (hFile, &header, sizeof (header), &nXfer, &ovZero))
					ReportError (_T("Program RecordAccess: blad aktualizacji w funkcji WriteFile."), 9, FALSE);
			}
		}

		if (prompt) _tprintf (_T("Liczba niepustych rekordow wynosi: %d\n"), header.numNonEmptyRecords);
		if (!ReadFile(hFile, &header, sizeof (HEADER), &nXfer, &ovZero))
			ReportError (_T("Blad programu RecordAccess: odczyt naglowka."), 10, TRUE);
		if (prompt) _tprintf (_T("Plik %s zawiera %d niepustych rekordow.\nPojemnosc: %d\n"),
			argv[1], header.numNonEmptyRecords, header.numRecords);

		CloseHandle (hFile);
		return 0;
	}
