/* Rozdzia 3. lsREG - polecenie do wywietlania zawartoci rejestru. */
/* lsREG [opcje] KluczPodrzedny
	Wymienianie par klucz-warto.
	Opcje:
		-R	rekurencja
		-l  wywietlanie rozbudowanych operacji (czasu ostatniego zapisu i
			typu wartoci). */

/* Ten program ilustruje:
		1.	Uchwyty rejestru i poruszanie si po nim.
		2.	Wartoci z rejestru.
		3.	Podobiestwa i rnice midzy poruszaniem si po katalogu
			i rejestrze. 

	Warto zauway, e nie ma wieloznacznych nazw plikw i naley okreli
	klucz podrzdny, a wywietlane s wszystkie pary klucz-warto. Przypomina to instrukcj
	ls z acuchem "SubKey\*" podanym jako specyfikator pliku. */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#include "Everything.h"

BOOL TraverseRegistry(HKEY, LPTSTR, LPTSTR, LPBOOL);
BOOL DisplayPair(LPTSTR, DWORD, LPBYTE, DWORD, LPBOOL);
BOOL DisplaySubKey(LPTSTR, LPTSTR, PFILETIME, LPBOOL);

int _tmain(int argc, LPTSTR argv[])
{
	BOOL flags[2], ok = TRUE;
	TCHAR keyName[MAX_PATH+1];
	LPTSTR pScan;
	DWORD i, keyIndex;
	HKEY hKey, hNextKey;

	/* Tablice predefiniowanych nazw i kluczy. */
	LPTSTR PreDefKeyNames[] = {
		_T("HKEY_LOCAL_MACHINE"),
		_T("HKEY_CLASSES_ROOT"),
		_T("HKEY_CURRENT_USER"),
		_T("HKEY_CURRENT_CONFIG"),
		NULL };
	HKEY PreDefKeys[] = {
		HKEY_LOCAL_MACHINE,
		HKEY_CLASSES_ROOT,
		HKEY_CURRENT_USER,
		HKEY_CURRENT_CONFIG };

		if (argc < 2) {
			_tprintf(_T("Stosowanie: lsREG[opcje] KluczPodrzedny\n"));
			return 1;
		}

	keyIndex = Options(argc, argv, _T("Rl"), &flags[0], &flags[1], NULL);

	/* "Przetwarzanie" szukanego wzorca na dwie czci: "klucz"
		i "klucz podrzdny". Klucz to pierwszy acuch zakoczony ukonikiem odwrotnym.
		Musi mie warto HKEY_LOCAL_MACHINE, HKEY_CLASSES_ROOT
		lub HKEY_CURRENT_USER. Klucz podrzdny to reszta acucha.
		Nazwy klucza i klucza podrzdnego s kopiowane z argumentu argv[keyIndex]. */

	/*  Budowanie klucza. */
	pScan = argv[keyIndex];
	for (i = 0; *pScan != _T('\\') && *pScan != _T('\0') && i < MAX_PATH; pScan++, i++)
		keyName[i] = *pScan;
	keyName[i] = _T('\0'); if (*pScan == _T('\\')) pScan++;

	/* Przeksztacanie predefiniowanej nazwy klucza na nazw HKEY. */
	for (	i = 0;
			PreDefKeyNames[i] != NULL && _tcscmp(PreDefKeyNames[i], keyName) != 0;
			i++) ;
	if (PreDefKeyNames[i] == NULL) ReportError(_T("Uzyj predefiniowanego klucza."), 1, FALSE);
	hKey = PreDefKeys[i];

	/*  pScan wskazuje pocztek acucha z kluczem podrzdnym. Nie jest bezporednio udokumentowane,
		e separator to \, jednak rozwizanie to dziaa prawidowo. */
	if (RegOpenKeyEx(hKey, pScan, 0, KEY_READ, &hNextKey) != ERROR_SUCCESS)
		ReportError(_T("Nie mozna otworzyc klucza podrzednego."), 2, TRUE);
	hKey = hNextKey;

	ok = TraverseRegistry(hKey, argv[keyIndex], NULL, flags);
	RegCloseKey(hKey);

	return ok ? 0 : 1;
}

BOOL TraverseRegistry(HKEY hKey, LPTSTR fullKeyName, LPTSTR subKey, LPBOOL flags)

/*	Poruszanie si po kluczu rejestru i wywietlanie par klucz-warto. Jeli ustawiona
	jest opcja -R, program przechodzi te po kluczach podrzdnych. 
	fullKeyName to "pena nazwa klucza" rozpoczynajca si od jednej z nazw odwierajcych
	kluczy, na przykad "HKEY_LOCAL_MACHINE".
	SubKey (moe mie warto null) to pozostaa cz cieki. */

{
	HKEY hSubKey;
	BOOL recursive = flags[0];
	LONG result;
	DWORD valueType, index;
	DWORD numSubKeys, maxSubKeyLen, numValues, maxValueNameLen, maxValueLen;
	DWORD subKeyNameLen, valueNameLen, valueLen;
	FILETIME lastWriteTime;
	LPTSTR subKeyName, valueName;
	LPBYTE value;
	/****  Przechowywanie na stosie duej tablicy, takiej jak fullSubKeyName, to zy pomys 
	 *  (lub - jeli wolisz - bardzo za praktyka programistyczna, a nawet przestpstwo). ****/
	/* 1) Poruszanie si po katalogu moe wymaga duo przestrzeni.
	 * 2) Wystpuje zagroenie przepenieniem stosu, co stanowi zagroenie bezpieczestwa.
	 * 3) Nie mona obsugiwa dugich cieek (> MAX_PATH) za pomoc przedrostka \\?\.
	 *    SUGESTIA: program lsW (rozdzia 3.) przedstawia lepsz implementacj i w odpowiedni sposb 
	                poprawia niniejszy program.
	 */

	TCHAR fullSubKeyName[MAX_PATH+1];

	/* Otwieranie uchwytu klucza. */

	if (RegOpenKeyEx(hKey, subKey, 0, KEY_READ, &hSubKey) != ERROR_SUCCESS)
		ReportError(_T("\nNie mozna otworzyc klucza podrzednego"), 2, TRUE);

	/*  Okrelanie maksymalnego rozmiaru na zwizanego z kluczem i alokacja pamici. */
	if (RegQueryInfoKey(hSubKey, NULL, NULL, NULL, 
		&numSubKeys, &maxSubKeyLen, NULL, 
		&numValues, &maxValueNameLen, &maxValueLen, 
		NULL, &lastWriteTime) != ERROR_SUCCESS)
			ReportError(_T("Nie mozna pobrac informacji o kluczu podrzednym."), 3, TRUE);
	subKeyName = malloc(TSIZE * (maxSubKeyLen+1));   /* Rozmiar w bajtach. */
	valueName  = malloc(TSIZE * (maxValueNameLen+1));
	value      = malloc(maxValueLen);      /* Rozmiar w bajtach. */

	/*  Pierwszy przebieg pod ktem par klucz-warto. */
	/*  Waen zaoenie: nikt nie edytuje rejestru dla tego klucza podrzdnego */
	/*  w czasie dziaania ptli. Taka operacja moe zmieni lub spowodowa dodanie wartoci. */
	for (	index = 0; index < numValues; index++) {
		valueNameLen = maxValueNameLen + 1; /* Bardzo czsty bd to zapominanie o ustawieniu */
		valueLen     = maxValueLen + 1;     /* tych wartoci; obie wartoci to parametry wejciowy i wyjciowy.  */
		result = RegEnumValue(hSubKey, index, valueName, &valueNameLen, NULL,
				&valueType, value, &valueLen);
		if (result == ERROR_SUCCESS && GetLastError() == 0)
			DisplayPair(valueName, valueType, value, valueLen, flags);
		/*  Jeli programista chce zmieni warto, jest to odpowiednie miejsce.
			RegSetValueEx(hSubKey, valueName, 0, valueType, pNewValue, NewValueSize); */
	}

	/*  Drugi przebieg dla kluczy podrzdnych. */
	for (index = 0; index < numSubKeys; index++) {
		subKeyNameLen = maxSubKeyLen + 1;
		result = RegEnumKeyEx(hSubKey, index, subKeyName, &subKeyNameLen, NULL,
				NULL, NULL, &lastWriteTime);
		if (GetLastError() == 0) {
			DisplaySubKey(fullKeyName, subKeyName, &lastWriteTime, flags);

			/*  Wywietlanie elementw dla kluczy podrzdnych, jeli okrelona jest opcja -R. */
			if (recursive) {
				_stprintf(fullSubKeyName, _T("%s\\%s"), fullKeyName, subKeyName);
				TraverseRegistry(hSubKey, fullSubKeyName, subKeyName, flags);
			}
		}
	}

	_tprintf(_T("\n"));
	free(subKeyName); 
	free(valueName);
	free(value);
	RegCloseKey(hSubKey);
	return TRUE;
}


BOOL DisplayPair(LPTSTR valueName, DWORD valueType,
						 LPBYTE value, DWORD valueLen,
						 LPBOOL flags)

/* Funkcja wywietlajca pary klucz-warto. */

{

	LPBYTE pV = value;
	DWORD i;

	_tprintf(_T("\n%s = "), valueName);
	switch (valueType) {
	case REG_FULL_RESOURCE_DESCRIPTOR: /* 9: lista zasobw w opisie sprztu. */
	case REG_BINARY: /* 3: dane binarne w dowolnej postaci. */ 
		for (i = 0; i < valueLen; i++, pV++)
			_tprintf(_T(" %x"), *pV);
		break;

	case REG_DWORD: /* 4: liczba 32-bitowa. */
		_tprintf(_T("%x"), (DWORD)*value);
		break;

	case REG_EXPAND_SZ: /* 2: acuch zakoczony znakiem pustym z nierozwinitymi odwoaniami
	                          do zmiennych rodowiskowych (na przykad "%PATH%"). */ 
	case REG_MULTI_SZ: /* 7: tablica acuchw zakoczych znakami pustymi (na kocu znajduj si dwa takie znaki). */
	case REG_SZ: /* 1: acuch zakoczony znakiem pustym. */ 
		_tprintf(_T("%s"), (LPTSTR)value);
		break;
	
	case REG_DWORD_BIG_ENDIAN: /* 5: 32-bitowa liczba w formacie starszy najpierw. */ 
	case REG_LINK: /* 6: dowizanie symboliczne Unicode. */
	case REG_NONE: /* 0: niezdefiniowany typ wartoci. */
	case REG_RESOURCE_LIST: /* 8: lista zasobw. */
 	default: _tprintf(_T(" ** Nie mozna wyswietlac wartosci typu: %d. Cwiczenie dla Czytelnika\n"), valueType);
		break;
	}

	return TRUE;
}

BOOL DisplaySubKey(LPTSTR keyName, LPTSTR subKeyName, PFILETIME pLastWrite, LPBOOL flags)
{
	BOOL longList = flags[1];
	SYSTEMTIME sysLastWrite;

	_tprintf(_T("\n%s"), keyName);
	if (_tcslen(subKeyName) > 0) _tprintf(_T("\\%s "), subKeyName);
	if (longList) {
		FileTimeToSystemTime(pLastWrite, &sysLastWrite);
		_tprintf(_T("	%02d/%02d/%04d %02d:%02d:%02d"),
				sysLastWrite.wMonth, sysLastWrite.wDay,
				sysLastWrite.wYear, sysLastWrite.wHour,
				sysLastWrite.wMinute, sysLastWrite.wSecond);
	}
	return TRUE;
}
