/* Rozdzia 3. Polecenie getn. */
/* getn plik      
	Pobiera z pliku okrelony rekord o staym rozmiarze.
	Uytkownik musi wpisa numer rekordu. Kady dany
	rekord jest pobierany i wywietlany do czasu zadania
	rekordu o numerze ujemnym.
	Zakadamy, e rekordy maj stay rozmiar i s tekstowe. */
/*	Okrelona jest maksymalna dugo wiersza (MAX_LINE_SIZE). */

/* Ten program ilustruje:
	1. Ustawianie wskanika pliku.
	2. Arytmetyk na wartociach typu LARGE_INTEGER i stosowanie 64-bitowych pozycji w pliku. */

#include "Everything.h"

#define MAX_LINE_SIZE 256

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hInFile;
	LARGE_INTEGER CurPtr;
	DWORD nRead, RecSize;
	TCHAR buffer[MAX_LINE_SIZE + 1];
	BOOL Exit = FALSE;
	LPTSTR p;
	int RecNo;

 	if (argc != 2)
		ReportError (_T ("Stosowanie: getn plik"), 1, FALSE);
	hInFile = CreateFile (argv [1], GENERIC_READ,
			0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hInFile == INVALID_HANDLE_VALUE)
		ReportError (_T ("Blad getn: nie mozna otworzyc pliku."), 2, TRUE);
	
	RecSize = 0;
		/* Pobieranie rozmiaru rekordu z pierwszego rekordu.
			Odczyt maksymalnego rozmiaru wiersza i wyszukiwanie sekwencji CR/LF. */

	if (!ReadFile (hInFile, buffer, sizeof (buffer), &nRead, NULL) || nRead == 0)
		ReportError (_T ("Nie ma danych do odczytu."), 1, FALSE);
	if ((p = _tstrstr (buffer, _T ("\r\n"))) == NULL)
		ReportError (_T ("Nie znaleziono konca wiersza."), 2, FALSE);
	/* Ignorowanie ostrzee z systemw Win64 dotyczcych moliwej utraty danych. */
	RecSize = (DWORD)(p - buffer + 2);	/* 2 na sekwencj CRLF. */

	_tprintf (_T ("Rozmiar rekordu to: %d\n"), RecSize);
	
	while (TRUE) {
		_tprintf (_T ("Podaj numer rekordu (liczbe ujemna, aby zakonczyc): "));
		_tscanf_s (_T ("%d"), &RecNo);
		if (RecNo < 0) break;

		CurPtr.QuadPart = (LONGLONG) RecNo * RecSize;
		if (!SetFilePointerEx (hInFile, CurPtr, NULL, FILE_BEGIN))
		/* Inna moliwo: zastosowanie struktury OVERLAPPED. */
			ReportError (_T ("Blad programu getn: ustawianie wskaznika."), 3, TRUE);
		if (!ReadFile (hInFile, buffer, RecSize,  &nRead, NULL) || (nRead != RecSize))
			ReportError (_T ("Blad odczytu n-tego rekordu."), 0, TRUE);
		buffer[RecSize] = _T('\0');
		_tprintf (_T ("%s\n"), buffer);
	}
	CloseHandle (hInFile);
	return 0;
}
