/*	Rozdzia 3. FreeSpace.c.
 *	Okrela, czy pliki s przechowywane w trybie rzadkim lub czy wykorzystana jest caa przestrze. */


#include "Everything.h"

void ReportSpace (LPCTSTR);

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hFile;
	LARGE_INTEGER FileLen, FileLenH;
	BYTE Buffer [256];
	OVERLAPPED ov;
	DWORD nWrite;

	while (TRUE) {
		FileLen.QuadPart = 0;
		_tprintf (_T("Wpisz dlugosc pliku (zero, aby zakonczyc): "));
		_tscanf_s (_T("%d"), &FileLen.QuadPart);
		_tprintf (_T("Dlugosc: %d\n"), FileLen.QuadPart);
		/* Uwaga: ta wersja nie obsuguje liczb wikszych ni 4 gigabajty.
			Potrafisz to naprawi? */
		if (FileLen.QuadPart== 0) break;
		FileLenH.QuadPart = FileLen.QuadPart/2;

		ReportSpace (_T("Przed utworzeniem pliku."));

		hFile = CreateFile (_T("TempTestFile"), GENERIC_READ|GENERIC_WRITE, 0, NULL,
			CREATE_NEW, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hFile == INVALID_HANDLE_VALUE)
			ReportError (_T("Nie mozna utworzyc pliku TempTestFile."), 2, TRUE);
		ReportSpace (_T("Po utworzeniu pliku."));

		if (!SetFilePointerEx (hFile, FileLen, NULL, FILE_BEGIN) == 0xffffffff)
			ReportError (_T("Nie mozna ustawic wskaznika pliku."), 3, TRUE);
		
		if (!SetEndOfFile (hFile))
			ReportError (_T("Nie mozna ustawic konca pliku."), 4, TRUE);
		ReportSpace (_T("Po ustawieniu dlugosci pliku."));

		ov.Offset = FileLenH.LowPart;
		ov.OffsetHigh = FileLen.HighPart;
		ov.hEvent = NULL; 

		if (!WriteFile (hFile, Buffer, sizeof(Buffer), &nWrite, &ov))
			ReportError (_T("Nie mozna zapisac pliku danych wewnatrz pliku."), 5, TRUE);
		
		ReportSpace (_T("Po zapisie danych wewnatrz pliku."));

		CloseHandle (hFile);
		DeleteFile (_T("TempTestFile"));
	}
	_tprintf (_T("Koniec programu FreeSpace."));
	return 0;
}


void ReportSpace (LPCTSTR Message)
{
	ULARGE_INTEGER FreeBytes, TotalBytes, NumFreeBytes;
	
	if (!GetDiskFreeSpaceEx (NULL, &FreeBytes, &TotalBytes, &NumFreeBytes))
		ReportError (_T("Nie mozna okreslic wolnej przestrzeni."), 1, TRUE);
	/* Uwaga: dotyczy systemw Windows NT 5.0 i nowszych (w tym 2000) - ten program
	mierzy przestrze dostpn dla uytkownika z uwzgldnieniem dyskw. */
	_tprintf (_T("%35s.\nW sumie: %16x; Wolna na dysku: %16x; Dostepna dla uzytkownika: %16x\n"), Message,
		TotalBytes.QuadPart, NumFreeBytes.QuadPart, FreeBytes.QuadPart);

}


 