/* "Szybka" implementacja programu cci_f.c z wszystkimi kombinacjami duego bufora (LB),
 *	flag skanowania sekwencyjnego (SS) i ustawie rozmiaru pliku wyjciowego (FS). 
 *	NB - brak bufora
 *	FL - oprnianie buforw pliku na kocu pracy. */
/* Umoliwia to eksperymenty nad rnorodnymi technikami poprawy
 * wydajnoci sekwencyjnego przetwarzania plikw. */

#define LB
//#undef LB
#define SS
//#undef SS
//#define FS
//#define NB

#include "Everything.h"

/* Czy zdefiniowano duy bufor? */

#ifdef LB
#define BUF_SIZE 8192
#endif
#ifndef LB
#define BUF_SIZE 256
#endif

/* Czy ustawiono flagi skanowania sekwencyjnego? */

#ifdef SS
#define SSF FILE_FLAG_SEQUENTIAL_SCAN
#endif
#ifndef SS
#define SSF 0
#endif

/* Bufor wejcia-wyjcia. */
#ifdef NB
#define NBF FILE_FLAG_NO_BUFFERING
#endif
#ifndef NB
#define NBF 0
#endif

/* Oprnianie buforw na kocu. */
#define FL

/* Usprawnienie w celu przyspieszenia przetwarzania plikw w systemach Win32 przez:
	uycie duych buforw,
	wstpne okrelenie wielkoci pliku wyjciowego,
	wykorzystanie flagi skanowania sekwencyjnego dla dwch plikw. */

BOOL cci_f (LPCTSTR fIn, LPCTSTR fOut,  DWORD shift)

/* Funkcja do szyfrowania pliku za pomoc szyfru CezaraCaesar - prosta implementacja:
 *		fIn:		cieka do pliku wejciowego
 *		fOut:		cieka do pliku docelowego
 *		shift:		liczbowe przesunicie
 *	Dziaanie jest oparte na funkcji CopyFile. */
{
	HANDLE hIn, hOut;
	DWORD nIn, nOut, iCopy;
	LARGE_INTEGER fileSize, filePosZero;
	CHAR aBuffer [BUF_SIZE], ccBuffer [BUF_SIZE];
	BOOL WriteOK = TRUE;
	filePosZero.QuadPart = 0;

	hIn = CreateFile (fIn, GENERIC_READ, 0, NULL, OPEN_EXISTING, 
			FILE_ATTRIBUTE_NORMAL | SSF | NBF, NULL);
	if (hIn == INVALID_HANDLE_VALUE) return FALSE;
	if (!GetFileSizeEx (hIn, &fileSize)) return FALSE;

	hOut = CreateFile (fOut, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
			FILE_ATTRIBUTE_NORMAL | SSF | NBF, NULL);
	if (hOut == INVALID_HANDLE_VALUE) return FALSE;

#ifdef FS
	SetFilePointerEx (hOut, fileSize, NULL, FILE_BEGIN);
	SetEndOfFile (hOut);
	SetFilePointerEx (hOut, 0, NULL, FILE_BEGIN);
#endif

	while (ReadFile (hIn, aBuffer, BUF_SIZE, &nIn, NULL) && nIn > 0 && WriteOK) {
		for (iCopy = 0; iCopy < nIn; iCopy++)
			ccBuffer [iCopy] = (BYTE)((aBuffer [iCopy] + shift) % 256);
		WriteOK = WriteFile (hOut, ccBuffer, nIn, &nOut, NULL);
	}

#ifdef FL
	FlushFileBuffers (hOut);
#endif
	CloseHandle (hIn);
	CloseHandle (hOut);

	return WriteOK;
}
