/* Rozdzia 2. Prosta implementacja funkcji cci_f (zmodyfikowany szyfr Cezara). */
#include "Everything.h"

#define BUF_SIZE 16384	  /* Oglnie lepsz wydajno zapewniaj wiksze bufory (wykorzystaj potgi liczby 2). 
					      /* 65536 daje dobre efekty. Due liczby nie pomagaj w pewnych prostych testach. */

BOOL cci_f (LPCTSTR fIn, LPCTSTR fOut, DWORD shift)

/* Funkcja stosujca szyfr Cezara - prosta implementacja.
 *		fIn:		cieka do rdowego pliku
 *		fOut:		cieka do docelowego pliku
 *		shift:		przesunicie liczbowe
 *	Dzianie jest oparte na funkcji CopyFile. */
{
	HANDLE hIn, hOut;
	DWORD nIn, nOut, iCopy;
	CHAR buffer [BUF_SIZE];
	BOOL writeOK = TRUE;

	hIn = CreateFile (fIn, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hIn == INVALID_HANDLE_VALUE) return FALSE;

	hOut = CreateFile (fOut, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hOut == INVALID_HANDLE_VALUE) {
		CloseHandle(hIn);
		return FALSE;
	}

	while (writeOK && ReadFile (hIn, buffer, BUF_SIZE, &nIn, NULL) && nIn > 0) {
		/* 24 marca 2010. W ksice i wczeniejszych wersjach programu uyto odrbnych buforw wejcia i wyjcia. Nie jest to konieczne i
		   i pogarsza wydajno z uwagi na dziaanie pamici podrcznej (dzikuj Melvinowi Smithowi za informacje o tym). JEDNAK, niektre 
		   aplikacje z operacjami odczyt-modyfikacja-zapis potrzebuj dwch buforw. Ten plik mona rozwin w pewien sposb. 
		   Ponadto wyniki z dodatku C s przydatne do porwnania rnych rnych implementacji i rnych platform. */
		for (iCopy = 0; iCopy < nIn; iCopy++)
			buffer[iCopy] = (BYTE)(buffer[iCopy] + shift) % 256;
		writeOK = WriteFile (hOut, buffer, nIn, &nOut, NULL);
	}

	CloseHandle (hIn);
	CloseHandle (hOut);

	return writeOK;
}
