/* Rozdzia 2. cat. */
/* cat [opcje] [pliki]
	Dostpna jest tylko opcja -s. Inne s ignorowane.
	Opcja -s blokuje zgaszanie bdu, jeli plik nie istnieje. */

#include "Everything.h"

#define BUF_SIZE 0x200

static VOID CatFile (HANDLE, HANDLE);
int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hInFile, hStdIn = GetStdHandle (STD_INPUT_HANDLE);
	HANDLE hStdOut = GetStdHandle (STD_OUTPUT_HANDLE);
	BOOL dashS;
	int iArg, iFirstFile;

	/*	Zmienna dashS jest ustawiana tylko wtedy, jeli w wierszu polece podano opcj "-s". */
	/*  Zmienna iFirstFile to indeks pierwszego pliku wejciowego z tablicy argv[]. */
	iFirstFile = Options (argc, argv, _T("s"), &dashS, NULL);

	if (iFirstFile == argc) { /* Brak plikw na licie argumentw. */
		CatFile (hStdIn, hStdOut);
		return 0;
	} 
	
	/* Przetwarzanie plikw wejciowych. */
	for (iArg = iFirstFile; iArg < argc; iArg++) {
		hInFile = CreateFile (argv [iArg], GENERIC_READ,
				0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hInFile == INVALID_HANDLE_VALUE) {
			if (!dashS) ReportError (_T ("Blad programu Cat: plik nie istnieje."), 0, TRUE);
		} else {
			CatFile (hInFile, hStdOut);
			if (GetLastError() != 0 && !dashS) {
				ReportError (_T ("Blad programu Cat: nie mozna przetworzyc calego pliku."), 0, TRUE);
			}
			CloseHandle (hInFile);
		}
	}
	return 0;
}

static VOID CatFile (HANDLE hInFile, HANDLE hOutFile)
{
	DWORD nIn, nOut;
	BYTE buffer [BUF_SIZE];

	while (ReadFile (hInFile, buffer, BUF_SIZE, &nIn, NULL) && (nIn != 0)
			&& WriteFile (hOutFile, buffer, nIn, &nOut, NULL));

	return;
}
