/* Rozdzia 1. Podstawowy program cp do kopiowania plikw. Implementacja dla systemw Win32.
	SZYBKA WERSJA UYWAJCA
		1.  DUEGO bufora
		2.  WSTPNIE OKRELONEGO ROZMIARU PLIKU WYJCIOWEGO
		3.  SKANOWANIA SEKWENCYJNEGO */
/* cpwFA plik1 plik2: kopiuje plik1 do plik2. */

#include <windows.h>
#include <stdio.h>
#define BUF_SIZE 8192

int main (int argc, LPTSTR argv [])
{
	HANDLE hIn, hOut;
	DWORD nIn, nOut;
	CHAR buffer [BUF_SIZE];
	if (argc != 3) {
		fprintf (stderr, "Stosowanie: cpwFA plik1 plik2\n");
		return 1;
	}
	hIn = CreateFile (argv [1], GENERIC_READ, 0, NULL, OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
	if (hIn == INVALID_HANDLE_VALUE) {
		fprintf (stderr, "Nie mozna otworzyc pliku wejsciowego. Blad: %x\n", GetLastError ());
		return 2;
	}
	hOut = CreateFile (argv [2], GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
			FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, NULL);
	if (hOut == INVALID_HANDLE_VALUE) {
		fprintf (stderr, "Nie mozna otworzyc pliku wyjsciowego. Blad: %x\n", GetLastError ());
		CloseHandle(hIn);
		return 3;
	}

	/*  Ustawianie rozmiaru pliku wyjciowego. */

	while (ReadFile (hIn, buffer, BUF_SIZE, &nIn, NULL) && nIn > 0) {
		WriteFile (hOut, buffer, nIn, &nOut, NULL);
		if (nIn != nOut) {
			fprintf (stderr, "Krytyczny blad zapisu: %x\n", GetLastError ());
			CloseHandle(hIn); CloseHandle(hOut);
			return 4;
		}
	}
	CloseHandle (hIn);
	CloseHandle (hOut);
	return 0;
}
