/* Rozdzia 1. Prosty program do kopiowania plikw - cpUC.c
	Implementacja zgodna z systemami Win32 i UNIX. */
/* cpUC plik1 plik2: kopiuje plik1 do plik2. */

#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#define BUF_SIZE 8192

int main (int argc, char *argv [])
{
	int fdIn, fdOut;
	int bytesIn, bytesOut;
	char rec[BUF_SIZE];
	if (argc != 3) {
		fprintf (stderr, "Stosowanie: cpUC plik1 plik2\n");
		return 1;
	}
	
	/* Zobacz stron http://msdn.microsoft.com/en-us/library/8ef0s5kh%28VS.80%29.aspx 
	 * dotyczc "bezpiecznych" zamiennikw funkcji _open.
	 * Warto zauway, e w tym projekcie zdefiniowano makro _CRT_SECURE_NO_WARNINGS,
     * aby unikn ostrzee. */
	fdIn = _open (argv[1], O_RDONLY);
	if (fdIn == -1) {
		perror (argv [1]);
		return 2;
	}
	fdOut = _open (argv[2], O_WRONLY | O_CREAT, 0666);
	if (fdOut == -1) {
		perror (argv[2]);
		_close(fdIn);
		return 3;
	}

/* Przetwarzanie pliku wejciowego po jednym rekordzie. */

	while ((bytesIn = _read (fdIn, &rec, BUF_SIZE)) > 0) {
		bytesOut = _write (fdOut, &rec, (unsigned int)bytesIn);
		if (bytesOut != bytesIn) {
			perror ("Krytyczny blad zapisu.");
			_close(fdIn); _close(fdOut);
			return 4;
		}
	}
	_close (fdIn);
	_close (fdOut);
	return 0;
}
