/* Rozdzia 1. Prosty program do kopiowania plikw. Implementacja UNIX-owa. */
/* cpU plik1 plik2: kopiuje plik1 do plik2. */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#define BUF_SIZE 256

int main (int argc, char *argv [])
{
	int input_fd, output_fd;
	ssize_t bytes_in, bytes_out;
	char rec [BUF_SIZE];
	if (argc != 3) {
		printf ("Stosowanie: cpU plik1 plik2\n");
		return 1;
	}
	input_fd = open (argv [1], O_RDONLY);
	if (input_fd == -1) {
		perror (argv [1]);
		return 2;
	}
	output_fd = open (argv [2], O_WRONLY | O_CREAT, 0666);
	if (output_fd == -1) {
		perror (argv [2]);
		return 3;
	}

/* Przetwarzanie pliku wejciowego po jednym rekordzie. */

	while ((bytes_in = read (input_fd, &rec, BUF_SIZE)) > 0) {
		bytes_out = write (output_fd, &rec, (size_t)bytes_in);
		if (bytes_out != bytes_in) {
			perror ("Krytyczny blad zapisu.");
			return 4;
		}
	}
	close (input_fd);
	close (output_fd);
	return 0;
}
