/* Rozdzia 1. Prosty program do kopiowania plikw. Implementacja oparta na bibliotece jzyka C. */
/* cpC plik1 plik2: kopiuje plik1 do plik2. */

#include <stdio.h>
#include <errno.h>
#define BUF_SIZE 256

int main (int argc, char *argv [])
{
	FILE *inFile, *outFile;
	char rec[BUF_SIZE];
	size_t bytesIn, bytesOut;
	if (argc != 3) {
		fprintf (stderr, "Stosowanie: cpC plik1 plik2\n");
		return 1;
	}

	/* W dalszych rozdziaach uyto bezpieczniejszych funkcji, takich jak fopen_s.
	 * Zobacz stron http://msdn.microsoft.com/en-us/library/8ef0s5kh%28VS.80%29.aspx.
	 * Warto zauway, e w projekcie zdefiniowano makro _CRT_SECURE_NO_WARNINGS,
     * aby unikn ostrzee. */
	inFile = fopen (argv[1], "rb");
	if (inFile == NULL) {
		perror (argv[1]);
		return 2;
	}
	outFile = fopen (argv[2], "wb");
	if (outFile == NULL) {
		perror (argv[2]);
		fclose(inFile);
		return 3;
	}

	/* Przetwarzanie pliku wejciowego po jednym rekordzie. */

	while ((bytesIn = fread (rec, 1, BUF_SIZE, inFile)) > 0) {
		bytesOut = fwrite (rec, 1, bytesIn, outFile);
		if (bytesOut != bytesIn) {
			perror ("Blad krytyczny zapisu.");
			fclose(inFile); fclose(outFile);
			return 4;
		}
	}

	fclose (inFile);
	fclose (outFile);
	return 0;
}
