#ifndef __errors_h
#define __errors_h

#ifndef _WINDOWS
#include <unistd.h>
#include <errno.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Na podstawie ksiki PWPT (Programming with POSIX Threads, David Butenhof, 
 * Addison-Wesley, 1997) s. 33 - 34.
 * Definiowanie makra, ktre mona wykorzysta do tworzenia danych diagnostycznych
 * w przykadach. Przy kompilacji z opcj -DDEBUG wywoana zostanie funkcja printf
 * z okrelon list argumentw. Jeli nazwa DEBUG nie jest zdefiniowana, nic
 * si nie dzieje.
 */
#ifdef DEBUG
#define DPRINTF(arg) printf arg
#else
#define DPRINTF(arg)
#endif

/*
 * UWAGA: nawiasy "do {" ... "} while(o);" wok makr umoliwiaj
 * stosowanie makr err_abort i errno_abort jak wywoa funkcji - 
 * take w kontekcie, gdzie kocowy redni, ";", spowodowaby
 * wygenerowanie pustej instrukcji. Na przykad kod:
 *
 *	if (status != 0)
 *		err_abort (status, "message");
 *	else
 *		return status;
 *
 * nie skompiluje si, jeli err_abort to makro koczce si znakiem "}".
 * Dzieje si tak, poniewa jzyk C nie oczekuje, e znak ";" znajdzie si 
 * po symbolu "}". Poniewa jzyk C oczekuje takiej sekwencji znakw
 * w konstrukcji do...while, makr err_abort i
 * errno_abort mona uywa tak, jak wywoa funkcji.
 */

#ifdef _WINDOWS
#define errno_get (FormatMessage ( \
				FORMAT_MESSAGE_FROM_SYSTEM, NULL, \
				GetLastError(), MAKELANGID (LANG_NEUTRAL, SUBLANG_DEFAULT), \
				Msg, 256, NULL),Msg)

#else
#define errno_get strerror(errno)
#endif

#define err_abort(code,text) do {\
 	fprintf (stderr, "%s at \"%s\":%d: %s\n", \
 		text, __FILE__, __LINE__, strerror (code)); \
 	abort (); \
 	} while (0)
#define errno_abort(text) do {char Msg[256]; \
 	fprintf (stderr, "%s at \"%s\":%d: %s\n", \
 		text, __FILE__, __LINE__, errno_get); \
 	abort (); \
 	} while (0)
#define err_stop(text) do {char Msg[256]; \
 	fprintf (stderr, "%s at %s: %d. %s\n", \
 		text, __FILE__, __LINE__, errno_get); \
 	return 1; \
 	} while (0)
#define err_stop0(text) do {\
 	fprintf (stderr, "%s at %s: %d.\n", \
 		text, __FILE__, __LINE__); \
 	return ; \
 	} while (0)

#endif
