/*  Thread_emulation.h		*/
/*		Autor: John Hart, July 27, 2000							*/
/*	Emuluje model Pthreads dla systemw Win32 i platoform z wtkami Pthreads. */
/*	Emulacja nie jest kompletna, ale obejmuje podzbir operacji */
/*	dla wielu poprawnie dziaajcych programw. */
/*  OSOBY, DLA KTRYCH DZIEDZINA TA MA ZNACZENIE, POWINNY UY BIBLIOTEKI DO OBSUGI WTKW PTHREADS */
/*  O OTWARTYM DOSTPIE DO KODU RDOWEGO. MONA J ZNALE W WITRYNIE PROJEKTU RED HAT. */
#ifndef _THREAD_EMULATION
#define _THREAD_EMULATION

/*	Makra do zarzdzania wtkami. */
#ifdef _WIN32
/*		Win32		*/
#define _WIN32_WINNT 0x500				// WINBASE.H - umoliwia stosowanie funkcji SignalObjectAndWait.
#include <process.h>
#include <windows.h>
#define		THREAD_FUNCTION		DWORD WINAPI
#define		THREAD_FUNCTION_RETURN DWORD
#define		THREAD_SPECIFIC_INDEX DWORD
#define		pthread_t	HANDLE
#define		pthread_attr_t DWORD
#define		pthread_create(thhandle,attr,thfunc,tharg) (int)((*thhandle=(HANDLE)_beginthreadex(NULL,0,(THREAD_FUNCTION)thfunc,tharg,0,NULL))==NULL)
#define		pthread_join(thread, result) ((WaitForSingleObject((thread),INFINITE)!=WAIT_OBJECT_0) || !CloseHandle(thread))
#define		pthread_detach(thread) if(thread!=NULL)CloseHandle(thread)
#define		thread_sleep(nms)	Sleep(nms)
#define		pthread_cancel(thread)	TerminateThread(thread,0)
#define		ts_key_create(ts_key, destructor) {ts_key = TlsAlloc();};
#define		pthread_getspecific(ts_key) TlsGetValue(ts_key)
#define		pthread_setspecific(ts_key, value) TlsSetValue(ts_key, (void *)value)
#define		pthread_self() GetCurrentThreadId()
#else
/*		pthreads	*/
/*		Prawie wszystko jest ju zdefiniowane. */
#define		THREAD_FUNCTION		void *
#define		THREAD_FUNCTION_RETURN void *
#define		THREAD_SPECIFIC_INDEX pthread_key_t
#define		thread_sleep(nms)	sleep((nms+500)/1000)
#define		ts_key_create(ts_key, destructor) pthread_key_create (&(ts_key), destructor);
#endif

/*       Makra do zapewniania synchronizacji: Win32 and Pthreads. */
#ifdef _WIN32
#define pthread_mutex_t					        HANDLE
#define pthread_cond_t					        HANDLE
#define pthread_mutex_lock(pobject)		        WaitForSingleObject(*pobject,INFINITE)
#define pthread_mutex_unlock(pobject)	        ReleaseMutex(*pobject)
#define pthread_mutex_init(pobject,pattr)       (*pobject=CreateMutex(NULL,FALSE,NULL))
#define pthread_cond_init(pobject,pattr)        (*pobject=CreateEvent(NULL,FALSE,FALSE,NULL))
#define pthread_mutex_destroy(pobject)          CloseHandle(*pobject)
#define pthread_cond_destroy(pobject)           CloseHandle(*pobject)
#define CV_TIMEOUT			INFINITE		/* Dostosowywana warto. */
/* DLA SYSTEMW WINDOWS 9X NALEY UY PONISZYCH DEFINICJI. */
/* Dodatkowe wyjanienia na temat emulacji zmiennej warunkowej i korzystania z limitu czasu
 * mona znale w pracy "Batons: A Sequential Synchronization Object" 
 * Andrew Tuckera i Johnsona M. Harta. (Windows Developers Journal, 
 * lipiec 2001, s. 24; www.wdj.com). */
//#define pthread_cond_wait(pcv,pmutex) 	{ReleaseMutex(*pmutex);WaitForSingleObject(*pcv,CV_TIMEOUT);WaitForSingleObject(*pmutex,INFINITE);};
/* W systemach Windows NT/2000/XP mona uy poniszych definicji i unikn limitu czasu. */
#define pthread_cond_wait(pcv,pmutex) 	{SignalObjectAndWait(*pmutex,*pcv,INFINITE,FALSE);WaitForSingleObject(*pmutex,INFINITE);};
//#define pthread_cond_broadcast(pcv)		PulseEvent(*pcv)
#define pthread_cond_signal(pcv)         SetEvent(*pcv)
static int						OnceFlag;
//static DWORD ThId;  /* Jest to nieeleganckie, ale potrzebne w systemach Win9x ze wzgldu na funkcj _beginthreadex. */
#else
/*	To nie Windows. Zakadamy, e to platforma z wtkami pthreads. */

#endif

#endif
