#ifndef __SYNCH_OBJ_H
#define __SYNCH_OBJ_H

#define CV_TIMEOUT 5  /* Parametr dla modelu zmiennej warunkowej. */


/* Bariera z progiem - DEFINICJA TYPU I FUNKCJE */
typedef struct THRESHOLD_BARRIER_TAG { 	/* Bariera z progiem */
	HANDLE bGuard;	/* Muteks obiektu. */
	HANDLE bEvent;	/* Zdarzenie z automatycznym zerowaniem: bCount >= bThreshold. */
	DWORD bCount;		/* Liczba wtkw, ktre osigny barier. */
	DWORD bThreshold;	/* Prg bariery. */
} THRESHOLD_BARRIER, *THB_OBJECT;

DWORD CreateThresholdBarrier (THB_OBJECT *, DWORD /* Prg. */);
DWORD WaitThresholdBarrier (THB_OBJECT);
DWORD CloseThresholdBarrier (THB_OBJECT);

/* Wartoci bdw. */
#define SYNCH_OBJ_NOMEM 1  /* Nie mona zaalokowa zasobw. */
#define SYNCH_OBJ_CREATE_FAILURE 2
#define SYNCH_OBJ_BUSY 3  /* Obiekt jest uywany i nie mona go zamkn. */

/*  SEMAFOR - DEFINICJA TYPU I FUNKCJE */
typedef struct ethread_semaphore_tag { 	/* Semafor. */
	HANDLE s_guard;	/* Mutekst obiektu. */
	HANDLE s_fcfs;		/* Uywany dla semaforw typu "pierwszy przyszed-pierwszy obsuony". */
	HANDLE s_broadcast;	/* Warto s_count zostaa zwikszona. */
	DWORD s_max;	/* Maksymalna liczba jednostek semafora. */
	DWORD s_count;	/* Obecna liczba jednostek semafora. */
	int f_fcfs;		/* "Pierwszy przyszed-pierwszy obsuony" lub "pierwszy dostpny". */
} ethread_semaphore_t;

/* Definicje zsynchronizowanej, ograniczonej kolejki. */
/* Kolejki s zaimplementowane jako tablice z przechodzcymi cyklicznie */
/* indeksami do najnowszego i najstarszego komunikatu. */
/* Kada kolejka obejmuje te muteks i */
/* zmienne warunkowe "niepusta" oraz "niepena". */
/* Istnieje te wskanik do tablicy komunikatw dowolnego typu. */

#if (defined(USE_WINDOWS_CV))
typedef struct QUEUE_OBJECT_TAG { 	/* Kolejka oglnego uytku. */
	SRWLOCK				qGuard;/* Chroni blok komunikatu. */
	CONDITION_VARIABLE	qNe;	/* Kolejka niepusta. */
	CONDITION_VARIABLE	qNf;	/* Kolejka niepena. */
	DWORD		qSize;	/* Maksymalny rozmiar kolejki. */
	DWORD		qFirst;	/* Indeks najstarszego komunikatu. */
	DWORD		qLast;	/* Indeks najnowszego komunikatu. */
	DWORD		QueueDestroyed;/* Kolejka zostaa usunita. */
	PVOID	msgArray;	/* Tablica qSize komunikatw. */
} QUEUE_OBJECT;
#else
typedef struct QUEUE_OBJECT_TAG { 	/* Kolejka oglnego uytku. */
	HANDLE	qGuard;/* Chroni blok komunikatu. */
	HANDLE	qNe;	/* Zdarzenie: kolejka niepusta. */
	HANDLE	qNf;	/* Zdarzenie: kolejka niepena.	*/
					/* S to dwa zdarzenia z rcznym zerowaniem dla modelu rozpowszechniania i 
					 * z automatycznym zerowaniem dla modelu ze zgaszaniem. */
	DWORD qSize;	/* Maksymalny rozmiar kolejki. */
	DWORD qFirst;	/* Indeks najstarszego komunikatu. */
	DWORD qLast;	/* Indeks najnowszego komunikatu. */
	char	*msgArray;	/* Tablica qSize komunikatw. */
} QUEUE_OBJECT;
#endif
/* Funkcje do zarzdzania kolejk. */
DWORD QueueInitialize (QUEUE_OBJECT *, DWORD, DWORD);
DWORD QueueDestroy (QUEUE_OBJECT *);
DWORD QueueDestroyed (QUEUE_OBJECT *);
DWORD QueueEmpty (QUEUE_OBJECT *);
DWORD QueueFull (QUEUE_OBJECT *);
DWORD QueueGet (QUEUE_OBJECT *, PVOID, DWORD, DWORD);
DWORD QueuePut (QUEUE_OBJECT *, PVOID, DWORD, DWORD);
DWORD QueueRemove (QUEUE_OBJECT *, PVOID, DWORD);
DWORD QueueInsert (QUEUE_OBJECT *, PVOID, DWORD);
void CALLBACK QueueShutDown (ULONG_PTR);

#endif
