/* support.h */
/* Definicje wszystkich staych symbolicznych i popularnych funkcji narzdziowych
	uywanych w przykadowych programach. */

/* Zdefiniuj modyfikator LIBSPEC dla nazw funkcji i innych importowanych/eksportowanych
 * symboli. Jest to potrzebne tylko przy budowaniu programw dla systemw Win32. Nie jest to 
 * potrzebne na przykad w systemach UNIX/Linux. Ponisza instrukcja #ifdef jest
 * nadmiarowa (przykady s budowane tylko dla systemw Win32), jednak jej stosowanie do dobry nawyk.
 * Bdzie przydatny w przyszoci, jeli bdziesz potrzebny bdzie przenony kod. 
 */
#ifdef WIN32
/* Przy budowaniu biblioteki statycznej jedyny potrzebny modyfikator to
   extern "C" przy wywoywaniu kodu z programu w jzyku C++. */
#ifdef _STATICLIB
#if defined (__cplusplus)
#define LIBSPEC extern "C"
#else
#define LIBSPEC
#endif  /* __cplusplus */
#endif  /* _STATICLIB */

/* Nie jest budowana biblioteka statyczna.
 * Mona wyeksportowa lub zaimportowa symbole (nazwy funkcji) w zalenoci od tego, czy
 * budowana jest biblioteka DLL (zdefiniowana jest nazwa UTILITY_EXPORTS), czy importowane s
 * nazwy z "klienckiego" programu wywoujcego. Klient w jzyku C++ wymaga deklaracji extern "C",
 * aby mona uywa konwencji wywoa z jzyka C (a nie z C++) i unikn dekorowania nazw z
 * jzyka C++ (nazywanego czsto "manglowaniem nazw").
 */
#if defined(UTILITY_4_0_EXPORTS)
#define LIBSPEC __declspec (dllexport)
#elif defined(__cplusplus)
#define LIBSPEC extern "C" __declspec (dllimport)
#else
#define LIBSPEC __declspec (dllimport)
#endif

#endif  /* Koniec instrukcji #ifdef WIN32. */

#define EMPTY _T ("")
#define YES _T ("y")
#define NO _T("n")
#define CR 0x0D
#define LF 0x0A
#define TSIZE sizeof (TCHAR)

/* Ograniczenia i stae. */

#define TYPE_FILE 1		/* Uywana w programach ls, rm i lsFP. */
#define TYPE_DIR 2
#define TYPE_DOT 3

#define MAX_OPTIONS 20	/* Maksymalna liczba opcji wiersza polece. */
#define MAX_ARG 1000	/* Maksymalna liczba argumentw wiersza polece. */
#define MAX_COMMAND_LINE MAX_PATH+50 /* Maksymalny rozmiar wiersza polece. */
#define MAX_PATH_LONG 32767  /* Bardzo dugie cieki z przedrostkiem \\?\. */
#define MAX_NAME 256    /* Dugo nazw - uytkownikw i grup. */

/* Czsto uywane funkcje. */

LIBSPEC BOOL ConsolePrompt (LPCTSTR, LPTSTR, DWORD, BOOL);
LIBSPEC BOOL PrintStrings (HANDLE, ...);
LIBSPEC BOOL PrintMsg (HANDLE, LPCTSTR);
LIBSPEC VOID ReportError (LPCTSTR, DWORD, BOOL);
LIBSPEC VOID ReportException (LPCTSTR, DWORD);
LIBSPEC DWORD Options (int, LPCTSTR *, LPCTSTR, ...);
LIBSPEC LPTSTR SkipArg (LPCTSTR);
LIBSPEC BOOL WindowsVersionOK (DWORD, DWORD);
LIBSPEC VOID GetArgs (LPCTSTR, int *, LPTSTR *);

/* Funkcje zabezpiecze. */

LPSECURITY_ATTRIBUTES InitializeUnixSA (DWORD, LPTSTR, LPTSTR, LPDWORD, LPDWORD, LPHANDLE);
LPSECURITY_ATTRIBUTES InitializeAccessOnlySA (DWORD, LPTSTR, LPTSTR, LPDWORD, LPHANDLE);
void DestroyUnixSA (LPSECURITY_ATTRIBUTES, LPHANDLE);

DWORD ReadFilePermissions (LPTSTR, LPTSTR, LPTSTR);
BOOL ChangeFilePermissions (DWORD, LPTSTR, LPDWORD, LPDWORD);
/*	Prostsze formy dostpne w Visual C++ 5.0. */
//PSECURITY_DESCRIPTOR InitializeSD (DWORD, LPTSTR, LPTSTR, LPDWORD);
/* Stae potrzebne w funkcjach zabezpiecze. */

#define LUSIZE 1024
#define ACCT_NAME_SIZE LUSIZE

#ifdef _UNICODE /* Trzeba doda t deklaracj. */
#define _tstrrchr wcsrchr
#else
#define _tstrrchr strrchr
#endif

#ifdef _UNICODE /* Trzeba doda t deklaracj. */
#define _tstrstr wcsstr
#else
#define _tstrstr strstr
#endif

#ifdef _UNICODE /* Trzeba doda t deklaracj. */
#define _memtchr wmemchr
#else
#define _memtchr memchr
#endif

/* 
 * Makro dodajce opnienie na podstawie cakowitoliczbowego
 * parametru. Jest to opnienie zwizane z prac procesora (program 
 * nie udostpnia wtedy dobrowolnie procesora). Symuluje to obliczenia.
 */

#define delay_cpu(n)  {\
	int i=0, j=0;\
	/* Wykonywanie niepotrzebnych oblicze. */\
	while (i < n) {\
		j = (int)(i*i + (float)(2*j)/(float)(i+1));\
		i++;\
	}\
}

