/* messages.h - uywany w wielu programach z rozdziaw 9. i 10. */

#define DATA_SIZE 256
typedef struct MSG_BLOCK_TAG { /* Blok komunikatu. */
	HANDLE	mGuard;	/* Muteks dla bloku komunikatu. */
	HANDLE  mConsumed; /* Zdarzenie: skonsumowano komunikat. */
				/* Produkowanie nowego lub zatrzymanie pracy.	*/
	HANDLE  mReady; /* Zdarzenie: komunikat jest gotowy. */
	/* Uwaga: muteks i zdarzenia nie s uywane przez niektre programy, na przykad
	 * programy 10.3, 4 i 5 (wieloetapowy potok), poniewa komunikaty znajduj si w
	 * chronionej kolejce. */
	int source; /* Tworzenie danych identyfikacyjnych producenta. */
	int destination;/* Dane identyfikacyjne wtku odbiorczego. */

	DWORD fReady;	 /* Naley ustawi na 1, jeli komunikat jest gotowy. Uywana w programach eventPC i simplePC */
	DWORD fStop;     /* Naley ustawi na 1 dla ostatniego komunikatu. */
		/* Flagi skonsumowania i gotowoci oraz zatrzymania.	*/
	int sequence; /* Numer porzdkowy bloku komunikatu. Warto ujemna oznacza ostatni komunikat. */
	time_t timestamp;
	DWORD checksum; /* Suma kontrolna zawartoci komunikatu. */
	DWORD data[DATA_SIZE]; /* Zawarto komunikatu. */
} MSG_BLOCK;

VOID MessageFill (MSG_BLOCK *, DWORD, DWORD, DWORD);
VOID MessageDisplay (MSG_BLOCK *);
