#ifndef __SYNCH_OBJ_H
#define __SYNCH_OBJ_H
/* Wersja dla obiektu CRITICAL_SECTION. */

#define CV_TIMEOUT 25  /* Parametr dla modelu CV. */

/* Bariera z progiem - DEFINICJA TYPU I FUNKCJE */
typedef struct THRESHOLD_BARRIER_TAG { 	/* Bariera z progiem. */
	HANDLE bGuard;	/* Muteks obiektu. */
	HANDLE bEvent;	/* Zdarzenie z automatycznym zerowaniem: bCount >= bThreshold. */
	DWORD bCount;		/* Liczba wtkw, ktre doszy do bariery. */
	DWORD bThreshold;	/* Prg bariery. */
} THRESHOLD_BARRIER, *THB_OBJECT;

DWORD CreateThresholdoBarrier (THB_OBJECT *, DWORD /* Prg. */);
DWORD WaitThresholdoBarrier (THB_OBJECT);
DWORD CloseThresholdoBarrier (THB_OBJECT);

/*  SEMAFOR - DEFINICJA TYPU I FUNKCJE */
typedef struct ethread_semaphore_tag { 	/* Semafor. */
	CRITICAL_SECTION s_guard;	/* Obiekt CRITICAL_SECTION dla obiektu. */
	HANDLE s_fcfs;		/* Uywany dla semaforw "pierwszy przyszed-pierwszy obsuony". */
	HANDLE s_broadcast;	/* Warto s_count zwikszya si. */
	DWORD s_max;	/* Maksymalna liczba jednostek semafora. */
	DWORD s_count;	/* Obecna liczba jednostek semafora. */
	int f_fcfs;		/* "Pierwszy przyszed-pierwszy obsuony" lub "pierwszy dostpny". */
} ethread_semaphore_t;

/* Definicje zsynchronizowanej, ograniczonej kolejki. */
/* Kolejki s zaimplementowane jako tablice z przechodzcymi cyklicznie */
/* indeksami do najnowszego i najstarszego komunikatu. */
/* Kada kolejka obejmuje te muteks i */
/* zmienne warunkowe "niepusta" oraz "niepena". */
/* Istnieje te wskanik do tablicy komunikatw dowolnego typu. */

#if (defined(USE_WINDOWS_CV))
typedef struct QUEUE_OBJECT_TAG { 	/* Kolejka oglnego uytku. */
	CRITICAL_SECTION	qGuard;/* Chroni blok komunikatu. */
	CONDITION_VARIABLE	qNe;	/* Kolejka niepusta. */
	CONDITION_VARIABLE	qNf;	/* Kolejka niepena. */
	DWORD	qSize;	/* Maksymalny rozmiar kolejki. */
	DWORD	qFirst;	/* Indeks najstarszego komunikatu. */
	DWORD	qLast;	/* Indeks najnowszego komunikatu. */
	DWORD	QueueDestroyed;/* Kolejka zostaa usunita. */
	char	*msgArray;	/* Tablica qSize komunikatw. */
} QUEUE_OBJECT;
#else
typedef struct QUEUE_OBJECT_TAG_T { 	/* Kolejka oglnego uytku. */
	CRITICAL_SECTION	qGuard;/* Chroni blok komunikatu. */
	HANDLE	qNe;	/* Kolejka niepusta. */
	HANDLE	qNf;	/* Kolejka niepena. */
	DWORD qSize;	/* Maksymalny rozmiar kolejki. */
	DWORD qFirst;	/* Indeks najstarszego komunikatu. */
	DWORD qLast;	/* Indeks najnowszego komunikatu. */
	DWORD QueueDestroyed;/* Kolejka zostaa usunita. */
	char	*msgArray;	/* Tablica qSize komunikatw. */
} QUEUE_OBJECT;
#endif

/* Funkcje do zarzdzania kolejkami. */
DWORD QueueInitialize (QUEUE_OBJECT *, DWORD, DWORD);
DWORD QueueDestroy (QUEUE_OBJECT *);
DWORD QueueDestroyed (QUEUE_OBJECT *);
DWORD QueueEmpty (QUEUE_OBJECT *);
DWORD QueueFull (QUEUE_OBJECT *);
DWORD QueueGet (QUEUE_OBJECT *, PVOID, DWORD, DWORD);
DWORD QueuePut (QUEUE_OBJECT *, PVOID, DWORD, DWORD);
DWORD QueueRemove (QUEUE_OBJECT *, PVOID, DWORD);
DWORD QueueInsert (QUEUE_OBJECT *, PVOID, DWORD);

#endif
