/* Definicje na potrzeby komunikacji klient-serwer. */
/* Komunikaty da i odpowiedzi. Bez kodowania Unicode, poniewa
	danie moe pochodzi z systemu Windows 95. */
/* Pola na dug komunikatu s bezporednio zadeklarowane jako 32-bitowe, 
   aby unikn wieloznacznoci i zagwarantowa wspdziaanie midzy
   systemami Win32 i przyszymi systemami Win64. */

#define MAX_RQRS_LEN 0x1000
#define MAX_MESSAGE_LEN MAX_RQRS_LEN

typedef struct {	/* Oglny komunikat. */
	LONG32 msgLen;	/* czna dugo dania (bez tego pola). */
	BYTE record [MAX_RQRS_LEN];
} MESSAGE;

typedef struct {	/* To samo, co MESSAGE. Jedynie pole na dugo ma inn nazw. */
	LONG32 rqLen;	/* czna dugo dania (bez tego pola). */
	BYTE record [MAX_RQRS_LEN];
} REQUEST;

typedef struct {	/* To samo, co MESSAGE. Jedynie pole na dugo ma inn nazw. */
	LONG32 rsLen;	/* czna dugo dania (bez tego pola). */
	BYTE record [MAX_RQRS_LEN];
} RESPONSE;

#define RQ_SIZE sizeof (REQUEST)
#define RQ_HEADER_LEN RQ_SIZE-MAX_RQRS_LEN
#define RS_SIZE sizeof (RESPONSE)
#define RS_HEADER_LEN RS_SIZE-MAX_RQRS_LEN

/* Struktura komunikatu szczeliny pocztowej. */
typedef struct {
	DWORD32 msStatus;
	DWORD32 msUtilization;
	TCHAR msName[MAX_PATH];
} MS_MESSAGE;

#define MSM_SIZE sizeof (MS_MESSAGE)

#define CS_TIMEOUT 5000
	/* Limit czasu dla pocze potoku nazwanego i ledzenia wydajnoci. */

#define MAX_CLIENTS  4 ///***10 /* Maksymalna liczba klientw serwera serverNP. */
#define MAX_SERVER_TH 4 /* Maksymalna liczba wtkw serwera serverNPCP. */
#define MAX_CLIENTS_CP 128 /* Maksymalna liczba klientw serwera serverNPCP. */

/* Nazwy klienta i serwera potoku oraz szczeliny pocztowej.
	Zobacz tabel 3. w ksice, aby zapozna si z nazwami katalogu gwnego innymi ni KROPKA. */

#define SERVER_PIPE _T ("\\\\.\\PIPE\\SERVER")
#define CLIENT_PIPE _T ("\\\\.\\PIPE\\SERVER")
#define MS_SRVNAME _T ("\\\\.\\MAILSLOT\\CLS_MAILSLOT")
#define MS_CLTNAME _T ("\\\\.\\MAILSLOT\\CLS_MAILSLOT")

/*  Oto inne nazwy. Naley ich uywa, jeli systemy klienta i serwera
	dziaaj w sieci. Ponadto serwer aplikacji moe wyszukiwa i
	tworzy uywan nazw.  */
//#define CLIENT_PIPE _T ("\\\\ServerName\\PIPE\\SERVER")
/*  Aby znale dowolny serwera aplikacji, naley uy pierwszej postaci.
	Druga forma pozwala znale specyficzny serwer. */
//#define MS_CLTNAME _T ("\\\\*\\MAILSLOT\\CLS_MAILSLOT")
//#define MS_CLTNAME _T ("\\\\MailslotServerName\\MAILSLOT\\CLS_MAILSLOT")

/*  Nazwy muteksu i semafora uywanych przez clientCO i
	serverMT.								*/
#define MX_NAME _T ("ClientServerMutex")
#define SM_NAME _T ("ClientServerSemaphore")

/* Nazwa programu rozpowszechniajcego nazw potoku. */

#define SERVER_BROADCAST _T ("SrvrBcst.exe")

/* Polecenia dla funkcji do przechowywania danych. */

#define CS_INIT			1
#define CS_RQSTART		2
#define CS_RQCOMPLETE	3
#define CS_REPORT		4
#define CS_TERMTHD		5

/* Funkcje pomocnicze dla klienta i serwera. */

BOOL LocateServer (LPTSTR, DWORD);

/* Potrzebne ze wzgldu na gniazda. */
#define SERVER_PORT 50000   /* Zarezerwowany port. */

