﻿// © 2011 IDesign Inc.
// Pytania? Komentarze? Odwiedź
// http://www.idesign.net

using System;
using System.ServiceModel;

[ServiceContract]
interface IRoleManager
{
   /// <summary>
   /// Dodaje wskazanuch użytkowników do określonej roli.
   /// </summary>
   [OperationContract]
   void AddUsersToRole(string application,string[] userNames,string role);

   /// <summary>
   /// Dodaje wskazanych użytkowników do określonych ról.
   /// </summary>
   [OperationContract]
   void AddUsersToRoles(string application,string[] userNames,string[] roles);

   /// <summary>
   /// Dodaje wskazanego użytkownika do określonej roli.
   /// </summary>
   [OperationContract]
   void AddUserToRole(string application,string userName,string role);

   /// <summary>
   /// Dodaje wskazanego użytkownika do określonych ról.
   /// </summary>
   [OperationContract]
   void AddUserToRoles(string application,string userName,string[] roles);

   /// <summary>
   /// Dodaje nową rolę do źródła danych.
   /// </summary>
   [OperationContract]
   void CreateRole(string application,string role);

   /// <summary>
   /// Usuwa rolę ze źródła danych. Jeśli argument throwOnPopulatedRole ma wartość true, zgłasza wyjątek w razie próby usunięcia roli zawierającej przynajmniej jednego członka.
   /// </summary>
   [OperationContract]
   bool DeleteRole(string application,string role,bool throwOnPopulatedRole);

   /// <summary>
   /// Usuwa wszystkie role ze źródła danych. Jeśli argument throwOnPopulatedRole ma wartość true, zgłasza wyjątek w razie próby usunięcia choć jednej roli zawierającej przynajmniej jednego członka
   /// </summary>
   [OperationContract]
   void DeleteAllRoles(string application,bool throwOnPopulatedRole);

   /// <summary>
   /// Zwraca listę wszystkich ról w danej aplikacji.
   /// </summary>
   [OperationContract]
   string[] GetAllRoles(string application);

   /// <summary>
   /// Zwraca listę ról, do których należy dany użytkownik.
   /// </summary>
   [OperationContract]
   string[] GetRolesForUser(string application,string userName);

   /// <summary>
   /// Zwraca listę użytkowników należących do wskazanej roli.
   /// </summary>
   [OperationContract]
   string[] GetUsersInRole(string application,string role);

   /// <summary>
   /// Zwraca wartość true, jeśli zarządzanie rolami jest włączone; w przeciwnym razie zwraca false.
   /// </summary>
   [OperationContract]
   bool IsRolesEnabled(string application);

   /// <summary>
   /// Zwraca wartość true, jeśli dana nazwa roli istnieje już w źródle danych; w przeciwnym razie zwraca false.
   /// </summary>
   [OperationContract]
   bool RoleExists(string application,string role);

   /// <summary>
   /// Usuwa wskazanego użytkownika z określonej roli.
   /// </summary>
   [OperationContract]
   void RemoveUserFromRole(string application,string userName,string roleName);

   /// <summary>
   /// Usuwa wskazanych użytkowników z określonej roli.
   /// </summary>
   [OperationContract]
   void RemoveUsersFromRole(string application,string[] users,string role);

   /// <summary>
   /// Usuwa wskazanego użytkownika z określonych ról.
   /// </summary>
   [OperationContract]
   void RemoveUserFromRoles(string application,string user,string[] roles);

   /// <summary>
   /// Usuwa wskazanych użytkowników z określonych ról.
   /// </summary>
   [OperationContract]
   void RemoveUsersFromRoles(string application,string[] users,string[] roles);
}
