﻿// © 2011 IDesign Inc.
// Pytania? Komentarze? Odwiedź
// http://www.idesign.net

using System;
using System.Web.Security;
using System.ServiceModel;
using System.Runtime.Serialization;


[DataContract]
public class UserInfo
{
   string m_Name;
   string m_Email;
   string m_PasswordQuestion;
   bool m_IsApproved;
   bool m_IsLockedOut;

   [DataMember]
   public string Email
   {
      get
      {
         return m_Email;
      }
      set
      {
         m_Email = value;
      }
   }
   [DataMember]
   public string PasswordQuestion
   {
      get
      {
         return m_PasswordQuestion;
      }
      set
      {
         m_PasswordQuestion = value;
      }
   }
   [DataMember]
   public bool IsApproved
   {
      get
      {
         return m_IsApproved;
      }
      set
      {
         m_IsApproved = value;
      }
   }
  [DataMember]
   public bool IsLockedOut
   {
      get
      {
         return m_IsLockedOut;
      }
      set
      {
         m_IsLockedOut = value;
      }
   } 
   [DataMember]
   public string Name
   {
      get
      {
         return m_Name;
      }
      set
      {
         m_Name = value;
      }
   }
   public UserInfo(string name,string email,string passwordQuestion,bool isApproved,bool isLockedOut)
   {
      Name = name;
      Email = email;
      PasswordQuestion = passwordQuestion;
      IsApproved = isApproved;
      IsLockedOut = isLockedOut;
   }
   public UserInfo()
   {}
}

[ServiceContract]
interface IMembershipManager
{
   /// <summary>
   /// Tworzy nowego użytkownika.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   MembershipCreateStatus CreateUser(string application,string userName,string password,string email,string passwordQuestion,string passwordAnswer,bool isApproved);

   /// <summary>
   /// Usuwa wskazanego użytkownika.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   bool DeleteUser(string application,string userName,bool deleteAllRelatedData);

   /// <summary>
   /// Usuwa wszystkich użytkowników i (opcjonalnie) wszystkie powiązane z nimi dane.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   void DeleteAllUsers(string application,bool deleteAllRelatedData);

   /// <summary>
   /// Zwraca użytkownika pasującego do przekazanego adresu poczty elektronicznej.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   string GetUserNameByEmail(string application,string email);

   /// <summary>
   /// Zwraca liczbę użytkowników, którzy aktualnie uzyskują dostęp do aplikacji.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   int GetNumberOfUsersOnline(string application);

   /// <summary>
   /// Aktualizuje rekord i status użytkownika. Może wymagać odpowiedzi na pytanie zdefiniowane dla hasła.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   void UpdateUser(string application,string userName,string email,string oldAnswer,string newQuestion,string newAnswer,bool isApproved,bool isLockedOut);

   /// <summary>
   /// Określa czas braku aktywności użytkownika (czas od ostatniej czynności wyrażony w minutach), po którym użytkownik nie jest traktowany jako aktywny (w przypadku nieaktywnego użytkownika). Zwraca liczbę minut od ostatniej czynności aktywnego użytkownika.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   int UserIsOnlineTimeWindow(string application);

   /// <summary>
   /// Zwraca wszystkich użytkowników reprezentowanych w bazie danych.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   string[] GetAllUsers(string application);

   /// <summary>
   /// Zwraca informacje na temat źródła danych dla określonego użytkownika.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   UserInfo GetUserInfo(string application,string userName);
}
