﻿// © 2011 IDesign Inc.
// Pytania? Komentarze? Odwiedź
// http://www.idesign.net

using System;
using System.ServiceModel;

[ServiceContract]
interface IApplicationManager
{
   /// <summary>
   /// Usuwa wszystkich użytkowników i wszystkie role z aplikacji oraz usuwa samą aplikację.
   /// </summary>
   /// <param name="application"></param>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   void DeleteApplication(string application);

   /// <summary>
   /// Usuwa wszystkie aplikacje oraz wszystkich użytkowników i wszystkie role z tych aplikacji.
   /// </summary>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   void DeleteAllApplications();
   
   /// <summary>
   /// Zwraca dostępne aplikacje.
   /// </summary>
   /// <returns></returns>
   [OperationContract]
   [TransactionFlow(TransactionFlowOption.Allowed)]
   string[] GetApplications();
}