﻿// © 2011 IDesign Inc.
// Pytania? Komentarze? Odwiedź
// http://www.idesign.net

using System;
using System.Diagnostics;
using System.ServiceModel;

namespace ServiceModelEx.ServiceBus
{
   public abstract class ServiceBufferResponseBase<T> : BufferedServiceBusClient<T> where T : class 
   {
      public ServiceBufferResponseBase() : base(new Uri(ResponseContext.Current.ResponseAddress))
      {
         Header = ResponseContext.Current;
                  
         // Uzyskuje dane uwierzytelniające używane przez hosta
         IServiceBusProperties properties = OperationContext.Current.Host as IServiceBusProperties;
         Debug.Assert(properties != null);

         Credential = properties.Credential;
      }
   }
}





