﻿                                                         /* Oczy cylonów */
// ------- Preambuła -------- //
#include <avr/io.h>                        /* Definiuje piny, porty, itd. */
#include <util/delay.h>                     /* Funkcje marnujące czas */
#define DELAYTIME 45                                   /* milisekundy */
#define LED_PORT                PORTB
#define LED_PIN                 PINB
#define LED_DDR                 DDRB
int main(void) {
  // -------- Inicjalizacja --------- //
  uint16_t x = 0x1234;
  uint8_t y;
  LED_DDR = 0xff;               /* Rejestr DDRB
                                   wszystkie piny jako wyjście */
  // ------ Pętla zdarzeń ------ //
  while (1) {
    x = 2053 * x + 13849;                 /* generator licz "losowych" */
    y = (x >> 8) & 0b00000111;       /* wybierz trzy bity z górnego bajtu */
    LED_PORT ^= (1 << y);                            /* przełącz jeden bit */
    _delay_ms(100);
  }                                                  /* Koniec pętli zdarzeń */
  return (0);
}
