#include <stdio.h>

// Deklarujemy geti oraz getj jako funkcje zewntrzne,
// aby uniemoliwi kompilatorowi propagowanie staych
// i  tym samym  zagwarantowa, e kod maszynowy
// bdzie demonstrowa interesujce nas konstrukcje.

extern int geti( void );
extern int getj( void );

// Przykad funkcji wbudowanej. Zwr uwag na sowo
// _inline, ktre sygnalizuje kompilatorowi MSVC++,
// e ma do czynienia z funkcj wbudowan jzyka C
// (sowo kluczowe inline jest stosowane w jzyku C++;
// w tym przypadku chcemy unikn stosowania mechanizmw jzyka C++,
// poniewa generowany kod maszynowy byby mniej czytelny).
//
//
// inlineFunc jest prost funkcj wbudowan, ktra
// dobrze pokazuje, jak kompilator jzyka C/C++ stosuje
// technik rozwijania ciaa wbudowanej funkcji w
// miejscu jej wywoania:

_inline int inlineFunc( int a, int b )
{
    return a + b;
}

_inline int ilf2( int a, int b )
{
    // Deklaruje kilka zmiennych, ktre wymusz konstrukcj
    // rekordu aktywacji (z uwagi na brak odpowiedniej przestrzeni 
    // w rejestrach procesora):

    int m;
    int c[4];
    int d;

    // Upewniamy si, e nasz program odwouje si do tablicy c,
    // aby uniemoliwi mechanizmom optymalizujcym kompilatora 
    // zignorowanie powyszej deklaracji:

    for( m = 0; m < 4; ++m )
    {
        c[m] = geti();
    }
    d = getj();
    for( m = 0; m < 4; ++m )
    {
        d += c[m];
    }

    // Zwraca wynik do programu wywoujcego:

    return (a + d) - b;
}


int main( int argc, char **argv )
{
    int i;
    int j;
    int sum;
    int result;

    i = geti();
    j = getj();
    sum = inlineFunc( i, j );
    result = ilf2( i, j );
    printf( "i+j=%d, wynik=%d\n", sum, result );
    return 0;
}
