#include <stdlib.h>

// Odpowiednio duy, cho strukturalnie przypadkowy rekord,
// ktry demonstruje sposb, w jaki kompilator jzyka C++ moe
// obsugiwa przypisywanie caych struktur.

typedef struct
{
    int x;
    int y;
    char *z;
    int a[16];
}aStruct;

int main( int argc, char **argv )
{
    static aStruct s1;
    aStruct s2;
    int i;

    // Przypisujemy zmiennej s1 warto rn od zera, aby
    // mechanizm optymalizujcy kompilatora nie zastpi
    // zerami wszystkich pl tego rekordu bdcych przedmiotem
    // odwoa:

    s1.x = 5;
    s1.y = argc;
    s1.z = *argv;

    // Przypisujemy w jednym wyraeniu ca struktur
    // (jest to moliwe tylko w jzyku C++!):

    s2 = s1;

    // Dokonujemy dowolnej zmiany w rekordzie S2,
    // aby mechanizm optymalizujcy kompilatora
    // nie mg wyeliminowa kodu budujcego zmienn
    // s2 i uy samej zmiennej s1 (poniewa bez tej
    // zmiany s1 i s2 byyby do koca identyczne).

    s2.a[2] = 2;

    // Take ponisza ptla ma na celu uniemoliwienie
    // mechanizmowi odpowiedzialnemu w kompilatorze za
    // optymalizacj kodu wyeliminowanie zmiennej s2:

    for( i = 0; i < 16; ++i)
    {
        printf( "%d\n", s2.a[i] );
    }

    // Poniej zastosowano technik przypisywania wartoci kolejnych pl obu
    // rekordw, aby zademonstrowa rnice w wygenerowanym kodzie maszynowym:

    s1.y = s2.y;
    s1.x = s2.x;
    s1.z = s2.z;
    for( i = 0; i < 16; ++i )
    {
        s1.a[i] = s2.a[i];
    }
    for( i = 0; i < 16; ++i)
    {
        printf( "%d\n", s2.a[i] );
    }
    return 0;
}
