public class FTD {
	/* Funkcje trygonometryczne - miara kta wyraona w stopniach */
	
	static double sin(double x) { /* sinus */
		return Math.sin(x/180*Math.PI);
    }
    static double cos(double x) { /* cosinus */
		return Math.cos(x/180*Math.PI);
    }
    static double tan(double x) { /* tangens */
		return Math.tan(x/180*Math.PI);
    }
    static double cot(double x) { /* cotangens */
		return 1/Math.tan(x/180*Math.PI);
    }
    static double sec(double x) { /* secans */
		return 1/Math.cos(x/180*Math.PI);
    }
    static double csc(double x) { /* cosecans */
		return 1/Math.sin(x/180*Math.PI);
    }
    
    /* Funkcje odwrotne do funkcji trygonometrycznych - wynik w stopniach */
    static double arcsin(double x) {
	    return Math.asin(x)/Math.PI*180;
    }
    static double arccos(double x) {
	    return Math.acos(x)/Math.PI*180;
    }
    static double arctan(double x) {
	    return Math.atan(x)/Math.PI*180;
    }
    static double arccot(double x) {
	    return Math.atan(1/x)/Math.PI*180;
    }
    static double arcsec(double x) {
	    return Math.acos(1/x)/Math.PI*180;
    }
    static double arccsc(double x) {
	    return Math.asin(1/x)/Math.PI*180;
    }
    
    /* Konwersje miar ktw */
    static double degToRad(double x) {
	    return x/180*Math.PI;
    }
    static double radToDeg(double x) {
	    return x/Math.PI*180;
    }
    
    /* To jest do zadania 18 */
    static String degToString(double x) {
	    StringBuffer str = new StringBuffer();
	    int tmp = (int)Math.floor(x);
	    str.append(tmp);
	    str.append("\u00B0");
	    x = (x-Math.floor(x))*60;
	    tmp = (int)Math.floor(x);
	    str.append(tmp);
	    str.append("\'");
	    x = (x-Math.floor(x))*60;
	    tmp = (int)Math.floor(x);
	    str.append(tmp);
	    str.append("\"");
	    return str.toString();
    }
    /* To jest do zadania 19 */
    static double parseDeg(String st) {
	    int pst = st.indexOf("\u00B0"); // stopie
	    if (pst == -1) {
		    int pmin = st.indexOf("\'");    // minuta ktowa
	        if (pmin == -1) {
	            int psek = st.indexOf("\"");    // sekunda ktowa
	            if (psek == -1)
	                return Double.NaN;
	            int sek = Integer.parseInt(st.substring(pmin+1, psek));
	            return sek/3600.0;
            }
	        int min = Integer.parseInt(st.substring(0, pmin));
	        int psek = st.indexOf("\"");    // sekunda ktowa
	        if (psek == -1)
	            return min/60.0;
	        int sek = Integer.parseInt(st.substring(pmin+1, psek));
	        return min/60.0+sek/3600.0;
        }
	    int s = Integer.parseInt(st.substring(0, pst));
	    int pmin = st.indexOf("\'");    // minuta ktowa
	    if (pmin == -1)
	        return s;
	    int min = Integer.parseInt(st.substring(pst+1, pmin));
	    int psek = st.indexOf("\"");    // sekunda ktowa
	    if (psek == -1)
	        return s+min/60.0;
	    int sek = Integer.parseInt(st.substring(pmin+1, psek));
	    return s+min/60.0+sek/3600.0;
    }
}