import java.util.*;
public class Matrix {
	private static Scanner cin = new Scanner(System.in);
	private static Random  rnd = new Random();
	
	private double[][] M;
	
	public Matrix(double[][] x) {
	    int r = x.length;    // liczba wierszy (rows)
	    int c = x[0].length; // liczba kolumn (columns)
	    M = new double[r][c];
	    for(int i = 0; i < r; ++i)
	        for(int j = 0; j < c; ++j)
	            M[i][j] = x[i][j];
    }
    
    public Matrix(int r, int c) {
	    /* r liczba wierszy (rows), c liczba kolumn (columns) */
	    M = new double[r][c];
    }
    
    public Matrix(Matrix x) {
	    int r = x.M.length;
	    int c = x.M[0].length;
	    M = new double[r][c];
	    for(int i = 0; i < r; ++i)
	        for(int j = 0; j < c; ++j)
	            M[i][j] = x.M[i][j];
    }
    
    public Matrix random() {
	    for(int i = 0; i < M.length; ++i)
            for(int j = 0; j < M[0].length; ++j) 
                M[i][j] = rnd.nextDouble();
        return this;
    }
    
    public Matrix input() {
	    for(int i = 0; i < M.length; ++i)
            for(int j = 0; j < M[i].length; ++j) {
	            System.out.printf("M[%d][%d] = ", i, j);
                M[i][j] = cin.nextDouble();
           }
        return this;
    }
    
    public Matrix printf(String format) {
	    for(int i = 0; i < M.length; ++i) {
            for(int j = 0; j < M[0].length; ++j)
                System.out.printf(format, M[i][j]);
            System.out.println();
        }
        return this;
    }
    
    public double getAt(int i, int j) {
	    return M[i][j];
    }
    
    public void setAt(int i, int j, double x) {
	    M[i][j] = x;
    }
      
    public int getRows() {
	    return M.length;
    }
    
    public int getColumns() {
	    return M[0].length;
    }
    
    public Matrix add(Matrix x) {
	    if (M.length != x.M.length || M[0].length != x.M[0].length)
		    throw new ArithmeticException("Niezgodne wymiary macierzy");
	    Matrix tmp = new Matrix(this); 
	    for(int i = 0; i < M.length; ++i) 
            for(int j = 0; j < M[0].length; ++j)
                tmp.M[i][j] = M[i][j]+x.M[i][j];
        return tmp;
    }
    
    public Matrix sub(Matrix x) {
	    if (M.length != x.M.length || M[0].length != x.M[0].length)
		    throw new ArithmeticException("Niezgodne wymiary macierzy");
	    Matrix tmp = new Matrix(this); 
	    for(int i = 0; i < M.length; ++i) 
            for(int j = 0; j < M[0].length; ++j)
                tmp.M[i][j] = M[i][j]-x.M[i][j];
        return tmp;
    }
    
    public Matrix mult(Matrix x) { 
        if (M[0].length != x.M.length)
		    throw new ArithmeticException("Niezgodne wymiary macierzy");
		Matrix tmp = new Matrix(M.length, x.M[0].length);
		for(int i = 0; i < M.length; ++i) 
            for(int j = 0; j < x.M[0].length; ++j)
                for(int k = 0; k < x.M.length; ++k)
                    tmp.M[i][j] += M[i][k]*x.M[k][j];
        return tmp; 
    } 
    public Matrix mult(double x) { 
        Matrix tmp = new Matrix(this);
		for(int i = 0; i < M.length; ++i) 
            for(int j = 0; j < M[0].length; ++j)
                tmp.M[i][j] *= x;
        return tmp; 
    }
    
    public Matrix upperTriangular() {
		if (M.length != M[0].length)
		    throw new ArithmeticException("To nie jest macierz kwadratowa");
		int n = M.length;
	    Matrix tmp = new Matrix(this);       
	    for(int i = 0; i < n-1; ++i)     
	        for(int j = i+1; j < n; ++j) {
		        if (tmp.M[i][i] != 0.0) {
			        double p = tmp.M[j][i]/tmp.M[i][i];
		            for(int k = 0; k < n; ++k)
	                    tmp.M[j][k] -= tmp.M[i][k]*p;  
		        } else {
			        for(int k = i+1; k < n; ++k) {
			            if (tmp.M[k][i] != 0.0) {
				            for(int m = 0; m < n; ++m) {
					            double temp = tmp.M[i][m];
					            tmp.M[i][m] = tmp.M[k][m];
					            tmp.M[k][m] = -temp;
				            }
				            break;
			            }    				        
		            }		            
                }
            }    
	    return tmp;
    } 
    
    public Matrix lowerTriangular() {
		if (M.length != M[0].length)
		    throw new ArithmeticException("To nie jest macierz kwadratowa");
		int n = M.length;
	    Matrix tmp = new Matrix(this); 
	    for(int i = n-1; i > 0; --i)        
	        for(int j = i-1; j >= 0; --j) {
		        if (tmp.M[i][i] != 0.0) {
			        double p = tmp.M[j][i]/tmp.M[i][i];
		            for(int k = 0; k < n; ++k)
	                    tmp.M[j][k] -= tmp.M[i][k]*p;
		        } else {
			        for(int k = i-1; k >= 0; --k) {
			            if (tmp.M[k][i] != 0.0) {
				            for(int m = 0; m < n; ++m) {
					            double temp = tmp.M[i][m];
					            tmp.M[i][m] = tmp.M[k][m];
					            tmp.M[k][m] = -temp;
				            }
				            break;
			            }    			        
		            }
                }
            }    
	    return tmp;
    }
    
    public Matrix diagonal() {
		if (M.length != M[0].length)
		    throw new ArithmeticException("To nie jest macierz kwadratowa");
		int n = M.length;    
	    Matrix tmp = new Matrix(this); 
	    for(int i = 0; i < n; ++i)     
	        for(int j = 0; j < n; ++j)  {
		        if (tmp.M[i][i] != 0.0) {
			        if (j != i) {
		                double p = tmp.M[j][i]/tmp.M[i][i];
		                for(int k = 0; k < n; ++k)
	                        tmp.M[j][k] -= tmp.M[i][k]*p;
                    }
		        } else {
			        for(int k = i+1; k < n; ++k) {
			            if (tmp.M[k][i] != 0.0) {
				            for(int m = 0; m < n; ++m) {
					            double p = tmp.M[i][m];
					            tmp.M[i][m] = tmp.M[k][m];
					            tmp.M[k][m] = -p;
				            }
				            break;
			            }    				        
		            }
                }
            }    
	    return tmp;
    }
    
    public Matrix inverse() {
		if (M.length != M[0].length)
		    throw new ArithmeticException("To nie jest macierz kwadratowa");
		int n = M.length;
		    
	    Matrix tmp = new Matrix(this);            
	    Matrix I = new Matrix(n, n);
	    for(int i = 0; i < n; ++i)
	        I.M[i][i] = 1.0;
	                  
	    for(int i = 0; i < n; ++i)     
	        for(int j = 0; j < n; ++j)  {
		        if (tmp.M[i][i] != 0.0) {
			        if (j != i) {
		                double p = tmp.M[j][i]/tmp.M[i][i];
		                for(int k = 0; k < n; ++k) {
	                        tmp.M[j][k] -= tmp.M[i][k]*p;
	                        I.M[j][k] -= I.M[i][k]*p;
                        }
                    }			        
		        } else {
                    for(int k = i+1; k < n; ++k) {
			            if (tmp.M[k][i] != 0.0) {
				            for(int m = 0; m < n; ++m) {
					            double temp = tmp.M[i][m];
					            tmp.M[i][m] = tmp.M[k][m];
					            tmp.M[k][m] = -temp;
					            temp = I.M[i][m];
					            I.M[i][m] = I.M[k][m];
					            I.M[k][m] = -temp;
				            }
				            break;
			            }    
		            }
                }
            }   
        for(int i = 0; i < n; ++i) 
            if (tmp.M[i][i] != 0.0) 
                for(int j = 0; j < n; ++j)
                    I.M[i][j] /= tmp.M[i][i];  
            else
                throw new ArithmeticException("Macierz odwrotna nie istnieje");   
	    return I;
    }
    
    public double det() {
		if (M.length != M[0].length)
		    throw new ArithmeticException("To nie jest macierz kwadratowa");
		int n = M.length;
	    Matrix tmp = new Matrix(this);       
	    for(int i = 0; i < n-1; ++i) {   
	        for(int j = i+1; j < n; ++j) {
		        if (tmp.M[i][i] != 0.0) {
			        double p = tmp.M[j][i]/tmp.M[i][i];
		            for(int k = 0; k < n; ++k)
	                    tmp.M[j][k] -= tmp.M[i][k]*p;  
		        } else {
			        for(int k = i+1; k < n; ++k) {
			            if (tmp.M[k][i] != 0.0) {
				            for(int m = 0; m < n; ++m) {
					            double temp = tmp.M[i][m];
					            tmp.M[i][m] = tmp.M[k][m];
					            tmp.M[k][m] = -temp;
				            }
				            break;
			            }    				        
		            }		            
                }
            }
        }
        double d = 1.0; 
        for(int i = 0; i < n; ++i)
            d *= tmp.M[i][i];       
	    return d;
    }
    
    public Matrix replaceCol(int k, Matrix c) {
		if (k < 0 || k > M[0].length-1 || c.M.length != M.length || c.M[0].length != 1)
		    throw new ArithmeticException("Niewaciwe dane");		
		int n = M.length;		    
	    Matrix tmp = new Matrix(this);            
	    for(int i = 0; i < n; ++i)
	        tmp.M[i][k] = c.M[i][0];
	    return tmp;
    }
} 