public class QuadratPoly {
    private int a, b, c;
    private int delta;
    
    public QuadratPoly(int a, int b, int c) {
	    if (a == 0)
	        throw new ArithmeticException("Niedozwolony parametr a = 0!");
        this.a = a;
        this.b = b;
        this.c = c;
        this.delta = b*b-4*a*c;
    }
    
    public int value(int n) {
	    return (a*n+b)*n+c;
    } 
    
    public double value(double x) {
	    return (a*x+b)*x+c;
    } 
    
    public int getDelta() {
        return delta;
    }
    
    @Override public String toString() {
        StringBuilder wz = new StringBuilder();
		if (a == -1)
		    wz.append("-");
		else if (a != 1)
		    wz.append(a);             
	    wz.append("x^2");
	    
		if (b == -1)
		    wz.append("-x");
		else if (b == 1)
		    wz.append("+x");
		else if (b > 1)
		    wz.append("+").append(b).append("x");
		else if (b < -1) 
		    wz.append(b).append("x");	
	
		if (c > 0) 
		    wz.append("+").append(c);
		else if (c < 0) 
		    wz.append(c);
		return wz.toString();
     }
     public int sgnDelta() {
        return (delta > 0)?1:(delta < 0)?-1:0;
     }
     
     public double getX1() {
         return (-b-Math.sqrt(delta))/(2*a);
     }
     
     public double getX2() {
         return (-b+Math.sqrt(delta))/(2*a);
     }
     
     public double getP() {
         return -(double)b/(2*a);
     }

     public double getQ() {
         return -(double)delta/(4*a);
     }
     
     public String getVertex() {
         return "("+getP()+", "+getQ()+")";
     }
     
     public String getCodomain() {
     StringBuilder s = new StringBuilder();
		if (isAPositive())
             s.append("<").append(getQ()).append(", +oo)");
        else     
             s.append("(-oo, ").append(getQ()).append(">");  
        return s.toString(); 
     }
     
     public boolean isAPositive() {
         return a > 0;
     }
     
     public QuadratPoly mult(int n) {
	    if (n == 0)
	        throw new ArithmeticException("Niewaciwy parametr, n = 0");
        return new QuadratPoly(n*a, n*b, n*c);
     }
     
     public String solutionQE() {
	     StringBuilder s = new StringBuilder("{"); 
	     switch (sgnDelta()) {
             case 1:
                 s.append(getX1()).append(", ").append(getX2()).append("}");
                 break;
             case 0:
                 s.append(getX1()).append("}");
             break;
             case -1: 
                 s.append("}");
             break;
        }   
        return s.toString();
    }
    private String solutionQIe1() {
	    StringBuilder s = new StringBuilder();
        switch (sgnDelta()) {
            case 1:
                if (isAPositive()) {
                    s.append("(-oo, ").append(getX1());
                    s.append(") lub (");
                    s.append(getX2()).append(", +oo)");
                } else {
                    s.append("(").append(getX2()).append(", ");
                    s.append(getX1()).append(")");
                }
                break;
            case 0:
                if (isAPositive()) 
	                s.append("R\\{").append(getX1()).append("}");
                else 
                    s.append("{}");
            break;
            case -1: 
                if (isAPositive()) 
                    s.append("R");
                else
                    s.append("{}");
            break;
        } 
        return s.toString();
    }
    
    private String solutionQIe2() {
	    StringBuilder s = new StringBuilder();
        switch (sgnDelta()) {
            case 1:
                if (isAPositive()) {
	                s.append("(-oo, ").append(getX1()).append("> lub <");
	                s.append(getX2()).append(", +oo)");
                } else {
                    s.append("<").append(getX2()).append(", ");
                    s.append(getX1()).append(">");
                }
                break;
            case 0:
                if (isAPositive())
	                s.append("R");
                else 
                    s.append("{").append(getX1()).append("}");
            break;
            case -1: 
                if (isAPositive()) 
	                s.append("R");
                else 
                    s.append("{}");
            break;
        } 
        return s.toString();
    }
    
    public String solutionQIe(String typ) {
	    if (typ.equals(">"))
	        return this.solutionQIe1();
	    else if (typ.equals(">="))
	        return this.solutionQIe2();  
	    else if (typ.equals("<"))
	        return this.mult(-1).solutionQIe1(); 
	    else if (typ.equals("<="))
	        return this.mult(-1).solutionQIe2();    
	    else 
	        throw new IllegalArgumentException("Niewaciwy parametr "+typ);
    }
    public QuadratPoly add(QuadratPoly w) {
	    int s = this.a+w.a;
	    if (s == 0)
	        throw new ArithmeticException("Wynik nie nie jest trjmianem kwadratowym");
	    return new QuadratPoly(s, this.b+w.b, this.c+w.c);
    }
        
    public QuadratPoly sub(QuadratPoly w) {
	    int s = this.a-w.a;
	    if (s == 0)
	        throw new ArithmeticException("Wynik nie nie jest trjmianem kwadratowym");
	    return new QuadratPoly(s, this.b-w.b, this.c-w.c);
    }
}