
#include "service.h"

service::service(boost::asio::io_service& service,
                 unsigned short port)
    : m_acceptor(service, tcp::endpoint(tcp::v4(), port))
    , m_socket(service)
{
}

void service::do_accept()
{
    m_acceptor.async_accept(
        m_socket, [this] (const boost::system::error_code& error) {
            if (!error) {
                // Utworzenie nowej sesji i rozpoczcie nasuchiwania
				// wiadomoci od klientw.
                make_shared_session(
                        std::move(m_socket),
                        m_emit
                    )->start();

            } else {
                // Jeli pojawi si bd poczenia,
				// poinformuj o tym.
                std::cerr << error.message() << std::endl;

            }

            // Nasuchiwanie kolejnego klienta.
            do_accept();
        });
}

