#include <iostream>
#include <vector>
#include <functional>

#include <range/v3/view.hpp>
#include <range/v3/action.hpp>
#include <range/v3/istream_range.hpp>
#include <range/v3/to_container.hpp>

using namespace ranges::v3;
using namespace std::placeholders;

std::string string_to_lower(const std::string &s) {
    return s | view::transform(tolower);
}

std::string string_only_alnum(const std::string &s) {
    return s | view::filter(isalnum);
}

int main(int argc, char *argv[])
{
    const int n = argc <= 1
                    ? 10
                    : atoi(argv[1]);

    const auto words =
               // Pobieranie zakresu sw (tokenw) ze strumienia cin
               istream_range<std::string>(std::cin)

               // Przeksztacanie liter we wszystkich sowach na mae
               | view::transform(string_to_lower)

               // Usuwanie ze sw znakw niebdcych alfanumerycznymi
               | view::transform(string_only_alnum)

               // Niektre sowa mog si skada jedynie ze znakw niebdcych alfanumerycznymi
               | view::remove_if(&std::string::empty)

               // W przypadku sortowania potrzebujemy kolekcji z dostpem swobodnym
               | to_vector | action::sort;


    const auto results =
               words

               // Grupowanie takich samych sw
               | view::group_by(std::equal_to<>())

               // Tworzenie pary, ktra zawiera sowo oraz czsto jego wystpowania
               | view::transform([] (const auto &group) {
                         const auto begin       = std::begin(group);
                         const auto end         = std::end(group);
                         const int  count       = distance(begin, end);
                         const std::string word = *begin;

                         return std::make_pair(count, word);
                     })

               // Sortowanie wynikowego zakresu wzgldem czstoci wystpowania sw
               | to_vector | action::sort;


    for (auto value: results | view::reverse // Najpierw najczciej wystpujce sowa
                             | view::take(n) // Interesuje nas 'n' najlepszych wynikw
            ) {
        std::cout << value.first << " " << value.second << std::endl;
    }

    return 0;
}
