package com.saorsa.tm.tests;

import java.io.*;

import junit.framework.TestCase;

import com.saorsa.tm.Sequence;

public class SequenceTest extends TestCase {

  public SequenceTest(String name) {
    super(name);
  }

  public void tearDown() {
    Sequence.clear();
  }

  public void testAddition() {
    assertTrue(!Sequence.hasSequence("A"));
    assertTrue(!Sequence.hasSequence("B"));
    assertTrue(!Sequence.hasSequence("C"));
    assertTrue(!Sequence.hasSequence("D"));

    Sequence sequenceA = Sequence.getSequence("A");
    assertTrue(Sequence.hasSequence("A"));
    assertTrue(!Sequence.hasSequence("B"));
    assertTrue(!Sequence.hasSequence("C"));
    assertTrue(!Sequence.hasSequence("D"));

    Sequence sequenceB = Sequence.getSequence("B");
    assertTrue(Sequence.hasSequence("A"));
    assertTrue(Sequence.hasSequence("B"));
    assertTrue(!Sequence.hasSequence("C"));
    assertTrue(!Sequence.hasSequence("D"));

    Sequence sequenceC = Sequence.getSequence("C");
    assertTrue(Sequence.hasSequence("A"));
    assertTrue(Sequence.hasSequence("B"));
    assertTrue(Sequence.hasSequence("C"));
    assertTrue(!Sequence.hasSequence("D"));

    Sequence sequenceD = Sequence.getSequence("D");
    assertTrue(Sequence.hasSequence("A"));
    assertTrue(Sequence.hasSequence("B"));
    assertTrue(Sequence.hasSequence("C"));
    assertTrue(Sequence.hasSequence("D"));
  }

  public void testRemoval() {
    Sequence sequenceA = Sequence.getSequence("A");
    Sequence sequenceB = Sequence.getSequence("B");
    Sequence sequenceC = Sequence.getSequence("C");
    Sequence sequenceD = Sequence.getSequence("D");
    assertTrue(Sequence.hasSequence("A"));
    assertTrue(Sequence.hasSequence("B"));
    assertTrue(Sequence.hasSequence("C"));
    assertTrue(Sequence.hasSequence("D"));

    Sequence.removeSequence("A");
    assertTrue(!Sequence.hasSequence("A"));
    assertTrue(Sequence.hasSequence("B"));
    assertTrue(Sequence.hasSequence("C"));
    assertTrue(Sequence.hasSequence("D"));

    Sequence.removeSequence("B");
    assertTrue(!Sequence.hasSequence("A"));
    assertTrue(!Sequence.hasSequence("B"));
    assertTrue(Sequence.hasSequence("C"));
    assertTrue(Sequence.hasSequence("D"));

    Sequence.removeSequence("C");
    assertTrue(!Sequence.hasSequence("A"));
    assertTrue(!Sequence.hasSequence("B"));
    assertTrue(!Sequence.hasSequence("C"));
    assertTrue(Sequence.hasSequence("D"));

    Sequence.removeSequence("D");
    assertTrue(!Sequence.hasSequence("A"));
    assertTrue(!Sequence.hasSequence("B"));
    assertTrue(!Sequence.hasSequence("C"));
    assertTrue(!Sequence.hasSequence("D"));
  }

  public void testSequencing() {
    Sequence aSequence = Sequence.getSequence("Test");
    assertNotNull(aSequence);
    assertEquals(1, aSequence.next());
    assertEquals(2, aSequence.next());
    assertEquals(3, aSequence.next());
    assertEquals(4, aSequence.next());
    assertEquals(5, aSequence.next());
  }

  public void testLoading() {
    StringReader reader = new StringReader(sequenceTestData);
    Sequence.load(reader);

    assertTrue(Sequence.hasSequence("A"));
    assertTrue(Sequence.hasSequence("B"));
    assertTrue(Sequence.hasSequence("C"));
    assertTrue(Sequence.hasSequence("D"));

    assertEquals(1, Sequence.getSequence("A").next());
    assertEquals(2, Sequence.getSequence("B").next());
    assertEquals(3, Sequence.getSequence("C").next());
    assertEquals(4, Sequence.getSequence("D").next());
  }

  public void testAsXML() {
    Sequence sequenceA = Sequence.getSequence("A");
    Sequence sequenceB = Sequence.getSequence("B");
    Sequence sequenceC = Sequence.getSequence("C");
    Sequence sequenceD = Sequence.getSequence("D");

    sequenceB.next();
    sequenceC.next();
    sequenceC.next();
    sequenceD.next();
    sequenceD.next();
    sequenceD.next();

    try {
      StringWriter writer = new StringWriter();
      Sequence.allToXML(writer);
      Sequence.clear();
      StringReader reader = new StringReader(writer.toString());
      Sequence.load(reader);
      assertTrue(Sequence.hasSequence("A"));
      assertTrue(Sequence.hasSequence("B"));
      assertTrue(Sequence.hasSequence("C"));
      assertTrue(Sequence.hasSequence("D"));

      assertEquals(1, Sequence.getSequence("A").next());
      assertEquals(2, Sequence.getSequence("B").next());
      assertEquals(3, Sequence.getSequence("C").next());
      assertEquals(4, Sequence.getSequence("D").next());
    } catch (IOException ex) {
      fail();
    }
  }

  private String sequenceTestData =
    "<sequences>" +
    "  <sequence name=\"A\" value=\"1\"/>" +
    "  <sequence name=\"B\" value=\"2\"/>" +
    "  <sequence name=\"C\" value=\"3\"/>" +
    "  <sequence name=\"D\" value=\"4\"/>" +
    "</sequences>";
}