
// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.*;
import java.util.LinkedList;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.saorsa.tm.*;
import com.saorsa.tm.printing.QuotePrinter;

public class QuoteEditor extends JPanel {
  public QuoteEditor(String theOutputDirectory, MainUI theMainUI) {
    outputdir = theOutputDirectory;
    myMainUI = theMainUI;
    quotes = new LinkedList(Quote.allQuotes());
    initComponents();
  }

  private void addQuote() {
    Customer theCustomer = CustomerChooser.showDialog(myMainUI);
    if (theCustomer != null) {
      Quote newQuote = Quote.newQuote(theCustomer, "Edit Quote Description");
      quotes.add(newQuote);
      tableModel.rowAdded(quotes.size() - 1);
      quoteTable.getSelectionModel().setSelectionInterval(
        quotes.size() - 1,
        quotes.size() - 1);
      deleteButton.setEnabled(true);
      invoiceButton.setEnabled(true);
      printButton.setEnabled(true);
    }
  }

  private void deleteQuote() {
    int selectedRow = quoteTable.getSelectedRow();
    if (selectedRow != -1) {
      quotes.remove(selectedRow);
      tableModel.rowRemoved(selectedRow);
      quoteTable.getSelectionModel().clearSelection();
      selectedQuote = null;
      deleteButton.setEnabled(false);
      invoiceButton.setEnabled(false);
      printButton.setEnabled(false);
    }
  }

  private void addItem() {
    Part aPart = PartChooser.showDialog(myMainUI);
    if (aPart != null) {
      selectedQuote.add(aPart, 0);
      currentLineitems.clear();
      currentLineitems.addAll(selectedQuote.items());
      itemTableModel.setLineitems(currentLineitems);
      deleteItemButton.setEnabled(true);
      ChangeTracker.getTracker("quote").set();
    }
  }

  private void deleteItem() {
    int selectedRow = itemTable.getSelectedRow();
    if (selectedRow != -1) {
      selectedQuote.remove(((Lineitem) currentLineitems.get(selectedRow)).getPart());
      currentLineitems.remove(selectedRow);
      itemTableModel.rowRemoved(selectedRow);
      itemTable.getSelectionModel().clearSelection();
      deleteItemButton.setEnabled(false);
      ChangeTracker.getTracker("quote").set();
    }
  }

  private void saveQuotes() {
    try {
      Quote.updateFrom(quotes);
      quotes.clear();
      quotes.addAll(Quote.allQuotes());
      tableModel.setQuotes(quotes);
    } catch (IOException ex) {
      JOptionPane.showMessageDialog(
        null,
        "Error saving quotes: \n" + ex.getMessage(),
        "Error Saving",
        JOptionPane.ERROR_MESSAGE);
    }
  }

  public boolean maybeSaveOutstandingChanges() {
    maybeSaveOutstandingLineitemChanges();
    if (ChangeTracker.getTracker("quote").anyChange()) {
      switch (JOptionPane
        .showConfirmDialog(
          null,
          "Do you want to save changes to Quotes?",
          "Quote data has changed",
          JOptionPane.YES_NO_CANCEL_OPTION,
          JOptionPane.QUESTION_MESSAGE)) {
        case 2 :
          return false;
        case 0 :
          saveQuotes();
        case 1 :
          return true;
        default :
          return true;
      }

    } else {
      return true;
    }
  }

  public void saveLineitems() {
    selectedQuote.updateLineitems(currentLineitems);
    ChangeTracker.getTracker("lineitem").reset();
  }

  private void maybeSaveOutstandingLineitemChanges() {
    if (ChangeTracker.getTracker("lineitem").anyChange()) {
      if (JOptionPane
        .showConfirmDialog(
          null,
          "Do you want to save changes to These lineitems?",
          "Lineitem data has changed",
          JOptionPane.YES_NO_OPTION,
          JOptionPane.QUESTION_MESSAGE)
        == 0) {
        saveLineitems();
      }
    }
  }

  private void createInvoice() {
    Invoice newInvoice =
      Invoice.newInvoiceWithAssociatedQuote(selectedQuote, "New Invoice");
    myMainUI.editInvoice(newInvoice);
  }

  private void printQuote() {
    try {
      File outFile =
        new File(outputdir + "quote-" + selectedQuote.getNumber() + ".html");
      new QuotePrinter(selectedQuote).printTo(
        new PrintWriter(new FileWriter(outFile)));
      Runtime.getRuntime().exec("netscape " + outFile.getAbsolutePath());
    } catch (IOException ex) {
      System.err.println("Printing failed");
    }
  }

  private void initComponents() {
    ChangeTracker.getTracker("lineitem").reset();
    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

    tableModel = new QuoteTableModel(quotes);
    quoteTable = new JTable(tableModel);
    quoteTable.getColumnModel().getColumn(0).setPreferredWidth(20);
    quoteTable.getColumnModel().getColumn(1).setPreferredWidth(10);
    quoteTable.getColumnModel().getColumn(2).setPreferredWidth(50);
    quoteTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane tableScrollPane = new JScrollPane(quoteTable);
    add(tableScrollPane);
    add(Box.createRigidArea(new Dimension(0, 10)));

    ListSelectionModel rowSM = quoteTable.getSelectionModel();
    rowSM.addListSelectionListener(new ListSelectionListener() {
      public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel) e.getSource();
        if (selectedQuote != null) {
          maybeSaveOutstandingLineitemChanges();
        }
        currentLineitems.clear();
        if (!lsm.isSelectionEmpty()) {
          int selectedQuoteNumber = lsm.getMinSelectionIndex();
          selectedQuote = (Quote) quotes.get(selectedQuoteNumber);
          currentLineitems.addAll(selectedQuote.items());
          deleteButton.setEnabled(true);
          invoiceButton.setEnabled(true);
          printButton.setEnabled(true);
          addItemButton.setEnabled(true);
          deleteItemButton.setEnabled(false);
        } else {
          selectedQuote = null;
          deleteButton.setEnabled(false);
          invoiceButton.setEnabled(false);
          printButton.setEnabled(false);
          addItemButton.setEnabled(false);
          deleteItemButton.setEnabled(false);
        }
        itemTableModel.setLineitems(currentLineitems);
      }
    });

    JPanel quoteButtonPanel = new JPanel();
    add(quoteButtonPanel);
    add(Box.createRigidArea(new Dimension(0, 10)));

    quoteButtonPanel.setLayout(new BoxLayout(quoteButtonPanel, BoxLayout.X_AXIS));

    newButton = new JButton("New Quote");
    newButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addQuote();
      }
    });
    quoteButtonPanel.add(newButton);

    quoteButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));

    deleteButton = new JButton("Delete Quote");
    deleteButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deleteQuote();
      }
    });
    quoteButtonPanel.add(deleteButton);

    quoteButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));

    JButton saveButton = new JButton("Save");
    saveButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        saveQuotes();
      }
    });
    quoteButtonPanel.add(saveButton);

    quoteButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));

    invoiceButton = new JButton("Create Invoice");
    invoiceButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        createInvoice();
      }
    });
    quoteButtonPanel.add(invoiceButton);

    quoteButtonPanel.add(Box.createHorizontalGlue());

    printButton = new JButton("Print");
    printButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        printQuote();
      }
    });
    quoteButtonPanel.add(printButton);

    itemTableModel = new LineitemTableModel(currentLineitems);
    itemTable = new JTable(itemTableModel);
    itemTable.getColumnModel().getColumn(0).setPreferredWidth(50);
    itemTable.getColumnModel().getColumn(1).setPreferredWidth(10);
    itemTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane itemTableScrollPane = new JScrollPane(itemTable);
    add(itemTableScrollPane);
    add(Box.createRigidArea(new Dimension(0, 10)));

    ListSelectionModel itemRowSM = itemTable.getSelectionModel();
    itemRowSM.addListSelectionListener(new ListSelectionListener() {
      public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel) e.getSource();
        if (!lsm.isSelectionEmpty()) {
          addItemButton.setEnabled(true);
          deleteItemButton.setEnabled(true);
        } else {
          addItemButton.setEnabled(false);
          deleteItemButton.setEnabled(false);
        }
      }
    });

    JPanel itemButtonPanel = new JPanel();
    itemButtonPanel.setLayout(new BoxLayout(itemButtonPanel, BoxLayout.X_AXIS));
    add(itemButtonPanel);

    addItemButton = new JButton("New Lineitem");
    addItemButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addItem();
      }
    });
    itemButtonPanel.add(addItemButton);

    itemButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));

    deleteItemButton = new JButton("Delete Lineitem");
    deleteItemButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deleteItem();
      }
    });
    itemButtonPanel.add(deleteItemButton);

  }

  private JButton newButton;
  private JButton deleteButton;
  private JButton invoiceButton;
  private JButton printButton;
  private LinkedList quotes;
  private LinkedList currentLineitems = new LinkedList();
  private JTable quoteTable;
  private JTable itemTable;
  private JButton addItemButton;
  private JButton deleteItemButton;
  private QuoteTableModel tableModel;
  private LineitemTableModel itemTableModel;
  private Quote selectedQuote = null;
  private String outputdir;
  private MainUI myMainUI;
}