// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.math.BigDecimal;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import com.saorsa.tm.Part;

public class PartTableModel extends AbstractTableModel {
  public PartTableModel(List allParts) {
    super();
    parts = allParts;
  }

  public void setParts(List someParts) {
    parts = someParts;
    fireTableDataChanged();
  }

  public String getColumnName(int col) {
    return columnNames[col];
  }

  public boolean isCellEditable(int row, int col) {
    return true;
  }

  public Object getValueAt(int row, int col) {
    Part thePart = (Part) parts.get(row);
    switch (col) {
      case 0 :
        return thePart.getName();
      case 1 :
        return thePart.getPrice();
      default :
        return null;
    }
  }

  public void setValueAt(Object value, int row, int col) {
    Part thePart = (Part) parts.get(row);
    switch (col) {
      case 0 :
        thePart.setName((String) value);
        break;
      case 1 :
        thePart.setPrice(new BigDecimal((String) value));
        break;
    }
  }

  public int getColumnCount() {
    return columnNames.length;
  }

  public int getRowCount() {
    return parts.size();
  }

  public void rowAdded(int rowNum) {
    fireTableRowsInserted(rowNum, rowNum);
  }

  public void rowRemoved(int rowNum) {
    fireTableRowsDeleted(rowNum, rowNum);
  }

  private List parts = null;
  private String[] columnNames = { "Part", "Price" };

}