// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.LinkedList;

import javax.swing.*;

import com.saorsa.tm.ChangeTracker;
import com.saorsa.tm.Part;

public class PartEditor extends JPanel {
  private static final String NEW_PART_DESCRIPTION = "New Part";

  public PartEditor(String theOutputDirectory) {
    outputdir = theOutputDirectory;
    parts = new LinkedList(Part.allParts());
    initComponents();
  }

  public void addPart() {
    Part newPart = Part.makeEmptyPart();
    parts.add(newPart);
    tableModel.rowAdded(parts.size() - 1);
  }

  public void deletePart() {
    int selectedRow = partTable.getSelectedRow();
    if (selectedRow != -1) {
      parts.remove(selectedRow);
      tableModel.rowRemoved(selectedRow);
    }
  }

  public void saveParts() {
    try {
      Part.updateFrom(parts);
      parts.clear();
      parts.addAll(Part.allParts());
      tableModel.setParts(parts);
    } catch (IOException ex) {
      JOptionPane.showMessageDialog(
        null,
        "Error saving parts: \n" + ex.getMessage(),
        "Error Saving",
        JOptionPane.ERROR_MESSAGE);
    }
  }

  public boolean maybeSaveOutstandingChanges() {
    if (ChangeTracker.getTracker("part").anyChange()) {
      switch (JOptionPane
        .showConfirmDialog(
          null,
          "Do you want to save changes to Parts?",
          "Part data has changed",
          JOptionPane.YES_NO_CANCEL_OPTION,
          JOptionPane.QUESTION_MESSAGE)) {
        case 2 :
          return false;
        case 0 :
          saveParts();
        case 1 :
          return true;
        default :
          return true;
      }

    } else {
      return true;
    }
  }

  private void initComponents() {
    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    
    tableModel = new PartTableModel(parts);
    partTable = new JTable(tableModel);
    partTable.getColumnModel().getColumn(0).setPreferredWidth(100);
    partTable.getColumnModel().getColumn(1).setPreferredWidth(20);
    partTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane tableScrollPane = new JScrollPane(partTable);
    add(tableScrollPane);
    JPanel buttonPanel = new JPanel();
    add(buttonPanel);

    newButton = new JButton("New");
    newButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addPart();
      }
    });
    buttonPanel.add(newButton);

    deleteButton = new JButton("Delete");
    deleteButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deletePart();
      }
    });
    buttonPanel.add(deleteButton);

    saveButton = new JButton("Save");
    saveButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        saveParts();
      }
    });
    buttonPanel.add(saveButton);
  }

  private LinkedList parts;
  private JTable partTable;
  private ListSelectionModel selectionModel;
  private PartTableModel tableModel;
  private JButton newButton;
  private JButton deleteButton;
  private JButton saveButton;
  private String outputdir;
}