// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import com.saorsa.tm.ChangeTracker;
import com.saorsa.tm.Part;

public class PartChooser extends JDialog {

  public static void initialize(Frame owner) {
    dialog = new PartChooser(owner);
  }

  public static Part showDialog(Component comp) {
    if (dialog != null) {
      if (ChangeTracker.getTracker("part").anyChangeEver()) {
        dialog.setListData(Part.allPartNames().toArray());
      }
      dialog.setVisible(true);
    } else {
      System.err.println("PartChooser was not initialized");
    }
    return value;
  }

  private static PartChooser dialog;
  private static Part value = null;

  public PartChooser(Frame owner) {
    super(owner, "Choose a Part", true);

    Container myContentPane = getContentPane();

    JPanel listPane = new JPanel();
    listPane.setLayout(new BoxLayout(listPane, BoxLayout.Y_AXIS));

    JLabel label = new JLabel("Available Parts:");
    listPane.add(label);
    listPane.add(Box.createRigidArea(new Dimension(0, 5)));
    partList = new JList(Part.allPartNames().toArray());
    JScrollPane partScroller = new JScrollPane(partList);
    listPane.add(partScroller);
    listPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));

    JButton okButton = new JButton("Ok");
    okButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        PartChooser.value = Part.findPartByName((String) (partList.getSelectedValue()));
        PartChooser.dialog.setVisible(false);
      }
    });

    JButton cancelButton = new JButton("Cancel");
    cancelButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        PartChooser.dialog.setVisible(false);
      }
    });

    JPanel buttonPane = new JPanel();
    buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
    buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
    buttonPane.add(Box.createHorizontalGlue());
    buttonPane.add(okButton);
    buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
    buttonPane.add(cancelButton);

    myContentPane.add(listPane, BorderLayout.CENTER);
    myContentPane.add(buttonPane, BorderLayout.SOUTH);

    pack();
  }

  protected void setListData(Object[] data) {
    partList.setListData(data);
  }

  JList partList;
}