// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

import com.saorsa.tm.Customer;
import com.saorsa.tm.Invoice;

public class InvoiceTableModel extends AbstractTableModel {
  public InvoiceTableModel(List allInvoices) {
    super();
    invoices = allInvoices;
  }

  public int indexOf(Invoice anInvoice) {
    return invoices.indexOf(anInvoice);
  }

  public void setInvoices(List someInvoices) {
    invoices = someInvoices;
    fireTableDataChanged();
  }

  public String getColumnName(int col) {
    return columnNames[col];
  }

  public Class getColumnClass(int c) {
    return getValueAt(0, c).getClass();
  }

  public boolean isCellEditable(int row, int col) {
    return col > 0;
  }

  public Object getValueAt(int row, int col) {
    Invoice theInvoice = (Invoice) invoices.get(row);
    switch (col) {
      case 0 :
        return new Integer(theInvoice.getNumber());
      case 1 :
        return theInvoice.getCustomer().getName();
      case 2 :
        return theInvoice.getDescription();
      default :
        return null;
    }
  }

  public void setValueAt(Object value, int row, int col) {
    Invoice theInvoice = (Invoice) invoices.get(row);
    switch (col) {
      case 0 :
        break;
      case 1 :
        Customer newCustomer = Customer.findCustomerByName((String) value);
        if (newCustomer == null) {
          JOptionPane.showMessageDialog(
            null,
            (String) value + " is not an existing customer",
            "Invalid Customer",
            JOptionPane.ERROR_MESSAGE);
        } else {
          theInvoice.setCustomer(newCustomer);
        }
        break;
      case 2 :
        theInvoice.setDescription((String) value);
        break;
    }
  }

  public int getColumnCount() {
    return columnNames.length;
  }

  public int getRowCount() {
    return invoices.size();
  }

  public void rowAdded(int rowNum) {
    fireTableRowsInserted(rowNum, rowNum);
  }

  public void rowRemoved(int rowNum) {
    fireTableRowsDeleted(rowNum, rowNum);
  }

  private List invoices = null;
  private String[] columnNames = { "Number", "Customer", "Description" };

}