// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import com.saorsa.tm.Customer;

public class CustomerTableModel extends AbstractTableModel {
  public CustomerTableModel(List allCustomers) {
    super();
    customers = allCustomers;
  }

  public void setCustomers(List someCustomers) {
    customers = someCustomers;
    fireTableDataChanged();
  }

  public String getColumnName(int col) {
    return columnNames[col];
  }

  public boolean isCellEditable(int row, int col) {
    return true;
  }

  public Object getValueAt(int row, int col) {
    Customer theCustomer = (Customer) customers.get(row);
    switch (col) {
      case 0 :
        return theCustomer.getName();
      case 1 :
        return theCustomer.getPhoneNumber();
      case 2 :
        return theCustomer.getAddress();
      default :
        return null;
    }
  }

  public void setValueAt(Object value, int row, int col) {
    Customer theCustomer = (Customer) customers.get(row);
    switch (col) {
      case 0 :
        theCustomer.setName((String) value);
        break;
      case 1 :
        theCustomer.setPhoneNumber((String) value);
        break;
      case 2 :
        theCustomer.setAddress((String) value);
        break;
    }
  }

  public int getColumnCount() {
    return columnNames.length;
  }

  public int getRowCount() {
    return customers.size();
  }

  public void rowAdded(int rowNum) {
    fireTableRowsInserted(rowNum, rowNum);
  }

  public void rowRemoved(int rowNum) {
    fireTableRowsDeleted(rowNum, rowNum);
  }

  private List customers = null;
  private String[] columnNames = { "Name", "Phone", "Address" };

}