package com.saorsa.tm.tests;

import com.saorsa.tm.ChangeTracker;
import junit.framework.*;

public class ChangeTrackerTest extends TestCase {
  public ChangeTrackerTest(String name) {
    super(name);
  }

  public void setUp() {
    ChangeTracker.clear();
  }

  public void testDirtyFlag() {
    ChangeTracker tracker = ChangeTracker.getTracker("tracker1");
    assertTrue(!tracker.anyChange());
    tracker.set();
    assertTrue(tracker.anyChange());
    tracker.reset();
    assertTrue(!tracker.anyChange());
  }

  public void testChangedFlag() {
    ChangeTracker tracker = ChangeTracker.getTracker("tracker1");
    assertTrue(!tracker.anyChangeEver());
    tracker.set();
    assertTrue(tracker.anyChangeEver());
    tracker.reset();
    assertTrue(tracker.anyChangeEver());
  }

  public void testLookup() {
    ChangeTracker tracker1 = ChangeTracker.getTracker("tracker1");
    ChangeTracker tracker2 = ChangeTracker.getTracker("tracker2");

    assertSame(ChangeTracker.getTracker("tracker1"), tracker1);
    assertSame(ChangeTracker.getTracker("tracker2"), tracker2);
  }
}