// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.printing;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Iterator;

import com.saorsa.tm.*;

/**
 * This class prints an invoice without item details.
 * It is used when the customer has contracted for a package price.
 */

public class PackageInvoicePrinter extends InvoicePrinter {
  public static void init() {
    InvoicePrinter.register("Package", new PackageInvoicePrinter());
  }

  public PackageInvoicePrinter() {}

  public void printTo(Invoice theInvoice, Writer writer) {
    try {
      printHeader(writer, Company.getInstance(), theInvoice);

      writer.write("<p><table width=\"100%\">\n");
      writer.write("<tr>");
      writer.write("<th align=\"left\">Qty.</th>");
      writer.write("<th align=\"left\">Item</th>");
      writer.write("</tr>\n");

      MessageFormat itemFormatter =
        new MessageFormat("<tr><td>{0,number,integer}</td><td>{1}</td></tr>\n");
      for (Iterator itemIterator = theInvoice.items().iterator();
        itemIterator.hasNext();
        ) {
        Lineitem item = (Lineitem) (itemIterator.next());
        writer.write(
          itemFormatter.format(
            new Object[] {
              new Integer(item.getQuantity()),
              item.getDescription(),
              new Double(item.getUnitPrice().doubleValue()),
              new Double(item.calcExtendedPrice().doubleValue())}));
      }
      writer.write("<tr><td></td></tr>");
      writer.write(
        MessageFormat.format(
          "<tr><td></td><td>Sub Total</td><td>{0,number,currency}</td></tr>\n",
          new Object[] { new Double(theInvoice.calculateSubTotal().doubleValue())}));
      writer.write(
        MessageFormat.format(
          "<tr><td></td><td>HST</td><td>{0,number,currency}</td></tr>\n",
          new Object[] { new Double(theInvoice.calculateHST().doubleValue())}));
      writer.write(
        MessageFormat.format(
          "<tr><td></td><td>Total</td><td>{0,number,currency}</td></tr>\n",
          new Object[] { new Double(theInvoice.calculateTotal().doubleValue())}));
      writer.write("</table>\n");
      printFooter(writer);
      writer.flush();
    } catch (IOException ex) {}
  }

  private Invoice theInvoice = null;
}