// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm;

import java.math.BigDecimal;
import java.util.*;

/**
 * This class encapsulates the commonallity between quotes and invoices.
 */

public abstract class Statement {

  protected Statement(Customer somebody, String aDescription, int aNumber) {
    this(somebody, aDescription, aNumber, new Date());
  }

  protected Statement(
    Customer somebody,
    String aDescription,
    int aNumber,
    Date aDate) {
    customer = somebody;
    description = aDescription;
    number = aNumber;
    date = aDate;
    getTracker().reset();
  }

  public int lineitemCount() {
    return lineitems.size();
  }

  public BigDecimal calculateSubTotal() {
    Collection items = lineitems.values();
    BigDecimal total = new BigDecimal(0.0);
    for (Iterator lineitemIterator = items.iterator();
      lineitemIterator.hasNext();
      ) {
      Lineitem aLineitem = (Lineitem) lineitemIterator.next();
      total = total.add(aLineitem.calcExtendedPrice());
    }
    return total;
  }

  public BigDecimal calculateHST() {
    return calculateSubTotal().multiply(new BigDecimal(0.15));
  }

  public BigDecimal calculateTotal() {
    return calculateSubTotal().multiply(new BigDecimal(1.15));
  }

  public void add(Part aPart, int qty) {
    Lineitem lineitemForPart = getLineitemForPart(aPart);
    lineitemForPart.addToQuantity(qty);
    lineitems.put(aPart, lineitemForPart);
    getTracker().set();
  }

  public void remove(Part aPart) {
    lineitems.remove(aPart);
  }

  public Set parts() {
    return lineitems.keySet();
  }

  public Collection items() {
    return lineitems.values();
  }

  public void updateLineitems(Collection newItems) {
    lineitems.clear();
    for (Iterator itemIterator = newItems.iterator(); itemIterator.hasNext();) {
      Lineitem anItem = (Lineitem) itemIterator.next();
      lineitems.put(anItem.getPart(), anItem);
    }
    getTracker().set();
  }

  public void setQuantityOf(Part aPart, int qty) {
    Lineitem lineitemForPart = getLineitemForPart(aPart);
    lineitemForPart.setQuantity(qty);
    lineitems.put(aPart, lineitemForPart);
    getTracker().set();
  }

  public int getQuantityOf(Part aPart) {
    Lineitem lineitemForPart = getLineitemForPart(aPart);
    return lineitemForPart.getQuantity();
  }

  private Lineitem getLineitemForPart(Part aPart) {
    Lineitem theItem = (Lineitem) lineitems.get(aPart);
    return (theItem == null) ? new Lineitem(aPart, 0) : theItem;
  }

  public int getNumber() {
    return number;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer newCustomer) {
    customer = newCustomer;
    getTracker().set();
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String newDescription) {
    description = newDescription;
    getTracker().set();
  }

  public Date getDate() {
    return date;
  }

  protected abstract ChangeTracker getTracker();

  protected int number;

  /**
   * @supplierCardinality 1 
   */
  protected Customer customer;

  /**
   * @link aggregation
   * @associates <{Lineitem}>
   * @supplierCardinality 1..*
   */
  protected Map lineitems = new HashMap();

  protected String description;

  protected Date date;

}