// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm;

import java.io.*;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;

import org.xml.sax.AttributeList;
import reh.SaxMapper.SaxMapper;
import reh.SaxMapper.TagTracker;

/**
 * This class generates a non-repeating sequence of numbers.
 * Used for generating things like invoice numbers.
 */

public class Sequence {
  private static void addSequence(String sequenceName, int initialValue) {
    Sequence aSequence = new Sequence(sequenceName, initialValue);
    sequences.put(sequenceName, aSequence);
  }

  public static Sequence getSequence(String sequenceName) {
    Sequence aSequence = (Sequence) sequences.get(sequenceName);
    if (aSequence == null) {
      aSequence = new Sequence(sequenceName);
      sequences.put(sequenceName, aSequence);
      save();
    }
    return aSequence;
  }

  public static void removeSequence(String sequenceName) {
    if (hasSequence(sequenceName)) {
      sequences.remove(sequenceName);
      save();
    }
  }

  public static boolean hasSequence(String sequenceName) {
    return sequences.containsKey(sequenceName);
  }

  public static void load(Reader reader) {
    SequenceLoader loader = new SequenceLoader();
    loader.fromXML(reader);
  }

  public static void allToXML(Writer writer) throws IOException {
    writer.write("<sequences>\n");
    for (Iterator sequenceIterator = sequences.values().iterator();
      sequenceIterator.hasNext();
      ) {
      Sequence aSequence = (Sequence) sequenceIterator.next();
      aSequence.toXML(writer);
    }
    writer.write("</sequences>");
    writer.flush();
  }

  private static void save() {
    try {
      if (filename != null) {
        FileWriter writer = new FileWriter(filename, false);
        allToXML(writer);
      }
    } catch (IOException ex) {
      System.err.println("Error saving sequences: " + ex.getMessage());
    }
  }

  public static void setFile(String aFilename) throws FileNotFoundException {
    filename = aFilename;
    FileReader reader = new FileReader(filename);
    load(reader);
  }

  public static void clear() {
    sequences.clear();
  }

  private static HashMap sequences = new HashMap();
  public static String filename = null;

  private Sequence(String sequenceName) {
    this(sequenceName, 1);
  }

  private Sequence(String sequenceName, int initialValue) {
    name = sequenceName;
    number = initialValue;
  }

  public int next() {
    int temp = number++;
    Sequence.save();
    return temp;
  }

  public void toXML(Writer writer) throws IOException {
    writer.write(
      MessageFormat.format(
        "\t<sequence name=\"{0}\" value=\"{1,number,integer}\"/>\n",
        new Object[] { name, new Integer(number)}));
  }

  private String name;
  private int number = 1;

  private static class SequenceLoader extends SaxMapper {

    public Object getMappedObject() {
      return null;
    }

    public TagTracker createTagTrackerNetwork() {
      TagTracker root = new TagTracker() {};

      TagTracker sequenceTracker = new TagTracker() {
        public void onStart(String localName, AttributeList atts) {
          String name = atts.getValue("name");
          int value = Integer.parseInt(atts.getValue("value"));
          Sequence.addSequence(name, value);
        }
      };
      root.track("/sequences/sequence", sequenceTracker);

      return root;
    }

    public void loadFromFile(String id) throws Exception {
      FileInputStream in = new FileInputStream(id);
      fromXML(in);
    }

  }
}