// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm;

import java.util.HashMap;
import java.util.Map;

/**
 * This class provides the ability to track whether something has changed.  
 * Access is though the class which maintains a collection of 
 * <code>ChangeTrackers</code>, allowing different aspects of a system to be tracked.
 * This is essentally an centralized <em>dirty flag</em> system.
 * 
 * <p>In addition to tracking pending changes (which can be cleared)
 * it also trackes long term changes by maintaining a non-resettable flag as well.
 */

public class ChangeTracker {
  public static ChangeTracker getTracker(String trackerName) {
    ChangeTracker aTracker = (ChangeTracker) trackers.get(trackerName);
    if (aTracker == null) {
      aTracker = new ChangeTracker();
      trackers.put(trackerName, aTracker);
    }
    return aTracker;
  }

  public static void clear() {
    trackers.clear();
  }

  private static Map trackers = new HashMap();

  protected ChangeTracker() {
    dirtyFlag = false;
    changeFlag = false;
  }

  public void set() {
    dirtyFlag = true;
    changeFlag = true;
  }

  public void reset() {
    dirtyFlag = false;
  }

  public boolean anyChange() {
    return dirtyFlag;
  }

  public boolean anyChangeEver() {
    return changeFlag;
  }

  private boolean dirtyFlag;
  private boolean changeFlag;

}