// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

import com.saorsa.tm.Customer;
import com.saorsa.tm.Quote;

public class QuoteTableModel extends AbstractTableModel {
  public QuoteTableModel(List allQuotes) {
    super();
    quotes = allQuotes;
  }

  public void setQuotes(List someQuotes) {
    quotes = someQuotes;
    fireTableDataChanged();
  }

  public String getColumnName(int col) {
    return columnNames[col];
  }

  public Class getColumnClass(int c) {
    return getValueAt(0, c).getClass();
  }

  public boolean isCellEditable(int row, int col) {
    return col > 0;
  }

  public Object getValueAt(int row, int col) {
    Quote theQuote = (Quote) quotes.get(row);
    switch (col) {
      case 0 :
        return new Integer(theQuote.getNumber());
      case 1 :
        return theQuote.getCustomer().getName();
      case 2 :
        return theQuote.getDescription();
      default :
        return null;
    }
  }

  public void setValueAt(Object value, int row, int col) {
    Quote theQuote = (Quote) quotes.get(row);
    switch (col) {
      case 0 :
        break;
      case 1 :
        Customer newCustomer = Customer.findCustomerByName((String) value);
        if (newCustomer == null) {
          JOptionPane.showMessageDialog(
            null,
            (String) value + " is not an existing customer",
            "Invalid Customer",
            JOptionPane.ERROR_MESSAGE);
        } else {
          theQuote.setCustomer(newCustomer);
        }
        break;
      case 2 :
        theQuote.setDescription((String) value);
        break;
    }
  }

  public int getColumnCount() {
    return columnNames.length;
  }

  public int getRowCount() {
    return quotes.size();
  }

  public void rowAdded(int rowNum) {
    fireTableRowsInserted(rowNum, rowNum);
  }

  public void rowRemoved(int rowNum) {
    fireTableRowsDeleted(rowNum, rowNum);
  }

  private List quotes = null;
  private String[] columnNames = { "Number", "Customer", "Description" };

}