
// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.*;
import java.util.LinkedList;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.saorsa.tm.*;
import com.saorsa.tm.printing.InvoicePrinter;

public class InvoiceEditor extends JPanel {
  public InvoiceEditor(String theOutputDirectory, MainUI parent) {
    outputdir = theOutputDirectory;
    myMainUI = parent;
    invoices = new LinkedList(Invoice.allInvoices());
    initComponents();
  }

  public void editInvoice(Invoice anInvoice) {
    int index = ((InvoiceTableModel) invoiceTable.getModel()).indexOf(anInvoice);
    if (index == -1) {
      addInvoice(anInvoice);
    } else {
      index = invoices.size() - 1;
    }
    invoiceTable.getSelectionModel().setSelectionInterval(index, index);
  }

  public void addInvoice() {
    Customer theCustomer = CustomerChooser.showDialog(myMainUI);
    if (theCustomer != null) {
      Invoice newInvoice =
        Invoice.newInvoice(theCustomer, "Edit Invoice Description");
      addInvoice(newInvoice);
      invoiceTable.getSelectionModel().setSelectionInterval(
        invoices.size() - 1,
        invoices.size() - 1);
    }
  }

  private void addInvoice(Invoice newInvoice) {
    invoices.add(newInvoice);
    selectedInvoice = newInvoice;
    deleteButton.setEnabled(true);
    printButton.setEnabled(true);
    addItemButton.setEnabled(true);
    deleteItemButton.setEnabled(false);
    tableModel.rowAdded(invoices.size() - 1);
  }

  public void deleteInvoice() {
    int selectedRow = invoiceTable.getSelectedRow();
    if (selectedRow != -1) {
      invoices.remove(selectedRow);
      tableModel.rowRemoved(selectedRow);
      selectedInvoice = null;
      invoiceTable.getSelectionModel().clearSelection();
      deleteButton.setEnabled(false);
      printButton.setEnabled(false);
      addItemButton.setEnabled(false);
      deleteItemButton.setEnabled(false);
    }
  }

  private void addItem() {
    Part aPart = PartChooser.showDialog(myMainUI);
    if (aPart != null) {
      selectedInvoice.add(aPart, 0);
      currentLineitems.clear();
      currentLineitems.addAll(selectedInvoice.items());
      itemTableModel.setLineitems(currentLineitems);
      deleteItemButton.setEnabled(true);
      ChangeTracker.getTracker("invoice").set();
    }
  }

  private void deleteItem() {
    int selectedRow = itemTable.getSelectedRow();
    if (selectedRow != -1) {
      selectedInvoice.remove(
        ((Lineitem) currentLineitems.get(selectedRow)).getPart());
      currentLineitems.remove(selectedRow);
      itemTableModel.rowRemoved(selectedRow);
      itemTable.getSelectionModel().clearSelection();
      deleteItemButton.setEnabled(false);
      ChangeTracker.getTracker("invoice").set();
    }
  }

  public void saveInvoices() {
    try {
      Invoice.updateFrom(invoices);
      invoices.clear();
      invoices.addAll(Invoice.allInvoices());
      tableModel.setInvoices(invoices);
    } catch (IOException ex) {
      JOptionPane.showMessageDialog(
        null,
        "Error saving invoices: \n" + ex.getMessage(),
        "Error Saving",
        JOptionPane.ERROR_MESSAGE);
    }
  }

  public boolean maybeSaveOutstandingChanges() {
    maybeSaveOutstandingLineitemChanges();
    if (ChangeTracker.getTracker("invoice").anyChange()) {
      switch (JOptionPane
        .showConfirmDialog(
          null,
          "Do you want to save changes to Invoices?",
          "Invoice data has changed",
          JOptionPane.YES_NO_CANCEL_OPTION,
          JOptionPane.QUESTION_MESSAGE)) {
        case 2 :
          return false;
        case 0 :
          saveInvoices();
        case 1 :
          return true;
        default :
          return true;
      }

    } else {
      return true;
    }
  }

  public void saveLineitems() {
    selectedInvoice.updateLineitems(currentLineitems);
    ChangeTracker.getTracker("lineitem").reset();
  }

  private void maybeSaveOutstandingLineitemChanges() {
    if (ChangeTracker.getTracker("lineitem").anyChange()) {
      if (JOptionPane
        .showConfirmDialog(
          null,
          "Do you want to save changes to These lineitems?",
          "Lineitem data has changed",
          JOptionPane.YES_NO_OPTION,
          JOptionPane.QUESTION_MESSAGE)
        == 0) {
        saveLineitems();
      }
    }
  }

  private void printInvoice(String printerName) {
    try {
      InvoicePrinter printer = InvoicePrinter.getPrinterNamed(printerName);
      File outFile =
        new File(outputdir + "full-invoice-" + selectedInvoice.getNumber() + ".html");
      printer.printTo(selectedInvoice, new PrintWriter(new FileWriter(outFile)));
      Runtime.getRuntime().exec("netscape " + outFile.getAbsolutePath());
    } catch (IOException ex) {
      System.err.println("Printing failed");
    }
  }

  private void initComponents() {
    ChangeTracker.getTracker("lineitem").reset();
    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

    // Invoice list
    tableModel = new InvoiceTableModel(invoices);
    invoiceTable = new JTable(tableModel);
    invoiceTable.getColumnModel().getColumn(0).setPreferredWidth(20);
    invoiceTable.getColumnModel().getColumn(1).setPreferredWidth(10);
    invoiceTable.getColumnModel().getColumn(2).setPreferredWidth(50);
    invoiceTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane tableScrollPane = new JScrollPane(invoiceTable);
    add(tableScrollPane);
    add(Box.createRigidArea(new Dimension(0, 10)));

    ListSelectionModel invoiceRowSM = invoiceTable.getSelectionModel();
    invoiceRowSM.addListSelectionListener(new ListSelectionListener() {
      public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel) e.getSource();
        if (selectedInvoice != null) {
          maybeSaveOutstandingLineitemChanges();
        }
        currentLineitems.clear();
        if (!lsm.isSelectionEmpty()) {
          int selectedInvoiceNumber = lsm.getMinSelectionIndex();
          selectedInvoice = (Invoice) invoices.get(selectedInvoiceNumber);
          currentLineitems.addAll(selectedInvoice.items());
          printButton.setEnabled(true);
          deleteButton.setEnabled(true);
          addItemButton.setEnabled(true);
          deleteItemButton.setEnabled(false);
        } else {
          selectedInvoice = null;
          printButton.setEnabled(false);
          deleteButton.setEnabled(false);
          addItemButton.setEnabled(false);
          deleteItemButton.setEnabled(false);
        }
        itemTableModel.setLineitems(currentLineitems);
      }
    });
    // invoice buttons
    JPanel invoiceButtonPanel = new JPanel();
    add(invoiceButtonPanel);
    add(Box.createRigidArea(new Dimension(0, 10)));

    invoiceButtonPanel.setLayout(
      new BoxLayout(invoiceButtonPanel, BoxLayout.X_AXIS));

    JButton newButton = new JButton("New Invoice");
    newButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addInvoice();
      }
    });
    invoiceButtonPanel.add(newButton);

    invoiceButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));

    deleteButton = new JButton("Delete Invoice");
    deleteButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deleteInvoice();
      }
    });
    invoiceButtonPanel.add(deleteButton);

    invoiceButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));

    JButton saveButton = new JButton("Save");
    saveButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        saveInvoices();
      }
    });
    invoiceButtonPanel.add(saveButton);

    invoiceButtonPanel.add(Box.createHorizontalGlue());

    // type of output
    String[] printerNames = InvoicePrinter.getPrinterNames();
    printerList = new JComboBox(printerNames);
    invoiceButtonPanel.add(printerList);

    invoiceButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));

    printButton = new JButton("Print");
    printButton.setEnabled(false);
    printButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        printInvoice((String) printerList.getSelectedItem());
      }
    });
    invoiceButtonPanel.add(printButton);

    // line item list
    itemTableModel = new LineitemTableModel(currentLineitems);
    itemTable = new JTable(itemTableModel);
    itemTable.getColumnModel().getColumn(0).setPreferredWidth(50);
    itemTable.getColumnModel().getColumn(1).setPreferredWidth(10);
    itemTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane itemTableScrollPane = new JScrollPane(itemTable);
    add(itemTableScrollPane);
    add(Box.createRigidArea(new Dimension(0, 10)));

    ListSelectionModel itemRowSM = itemTable.getSelectionModel();
    itemRowSM.addListSelectionListener(new ListSelectionListener() {
      public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel) e.getSource();
        if (!lsm.isSelectionEmpty()) {
          addItemButton.setEnabled(true);
          deleteItemButton.setEnabled(true);
        } else {
          addItemButton.setEnabled(false);
          deleteItemButton.setEnabled(false);
        }
      }
    });

    // item buttons
    JPanel itemButtonPanel = new JPanel();
    itemButtonPanel.setLayout(new BoxLayout(itemButtonPanel, BoxLayout.X_AXIS));
    add(itemButtonPanel);

    addItemButton = new JButton("New Lineitem");
    addItemButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addItem();
      }
    });
    itemButtonPanel.add(addItemButton);

    itemButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));

    deleteItemButton = new JButton("Delete Lineitem");
    deleteItemButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deleteItem();
      }
    });
    itemButtonPanel.add(deleteItemButton);

  }

  private JButton deleteButton;
  private JComboBox printerList;
  private JButton printButton;
  private LinkedList invoices;
  private LinkedList currentLineitems = new LinkedList();
  private JTable invoiceTable;
  private JTable itemTable;
  private JButton addItemButton;
  private JButton deleteItemButton;
  private InvoiceTableModel tableModel;
  private LineitemTableModel itemTableModel;
  private Invoice selectedInvoice = null;
  private String outputdir;
  private MainUI myMainUI;
}