
// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.LinkedList;

import javax.swing.*;

import com.saorsa.tm.ChangeTracker;
import com.saorsa.tm.Customer;

public class CustomerEditor extends JPanel {
  private static final String NEW_Customer_DESCRIPTION = "New Customer";

  public CustomerEditor(String theOutputDirectory) {
    outputdir = theOutputDirectory;
    customers = new LinkedList(Customer.allCustomers());
    initComponents();
  }

  public void addCustomer() {
    Customer newCustomer = Customer.makeEmptyCustomer();
    customers.add(newCustomer);
    tableModel.rowAdded(customers.size() - 1);
  }

  public void deleteCustomer() {
    int selectedRow = customerTable.getSelectedRow();
    if (selectedRow != -1) {
      customers.remove(selectedRow);
      tableModel.rowRemoved(selectedRow);
    }
  }

  public void saveCustomers() {
    try {
      Customer.updateFrom(customers);
      customers.clear();
      customers.addAll(Customer.allCustomers());
      tableModel.setCustomers(customers);
    } catch (IOException ex) {
      JOptionPane.showMessageDialog(
        null,
        "Error saving customers: \n" + ex.getMessage(),
        "Error Saving",
        JOptionPane.ERROR_MESSAGE);
    }
  }

  public boolean maybeSaveOutstandingChanges() {
    if (ChangeTracker.getTracker("customer").anyChange()) {
      switch (JOptionPane
        .showConfirmDialog(
          null,
          "Do you want to save changes to Customers?",
          "Customer data has changed",
          JOptionPane.YES_NO_CANCEL_OPTION,
          JOptionPane.QUESTION_MESSAGE)) {
        case 2 :
          return false;
        case 0 :
          saveCustomers();
        case 1 :
          return true;
        default :
          return true;
      }

    } else {
      return true;
    }
  }

  private void initComponents() {
    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    
    tableModel = new CustomerTableModel(customers);
    customerTable = new JTable(tableModel);
    customerTable.getColumnModel().getColumn(0).setPreferredWidth(20);
    customerTable.getColumnModel().getColumn(1).setPreferredWidth(10);
    customerTable.getColumnModel().getColumn(2).setPreferredWidth(50);
    customerTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    JScrollPane tableScrollPane = new JScrollPane(customerTable);
    add(tableScrollPane);
    JPanel buttonPanel = new JPanel();
    add(buttonPanel);

    newButton = new JButton("New");
    newButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addCustomer();
      }
    });
    buttonPanel.add(newButton);

    deleteButton = new JButton("Delete");
    deleteButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        deleteCustomer();
      }
    });
    buttonPanel.add(deleteButton);

    saveButton = new JButton("Save");
    saveButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        saveCustomers();
      }
    });
    buttonPanel.add(saveButton);
  }

  private LinkedList customers;
  private JTable customerTable;
  private ListSelectionModel selectionModel;
  private CustomerTableModel tableModel;
  private JButton newButton;
  private JButton deleteButton;
  private JButton saveButton;
  private String outputdir;
}