// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.printing;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.*;

import com.saorsa.tm.Company;
import com.saorsa.tm.Invoice;

/**
 * This class contains behaviour that is common to all invoice printers
 */

public abstract class InvoicePrinter {

  public static void init() {
    FullInvoicePrinter.init();
    PackageInvoicePrinter.init();
  }

  protected static void register(String printerName, InvoicePrinter aPrinter) {
    printers.put(printerName, aPrinter);
  }

  public static InvoicePrinter getPrinterNamed(String printerName) {
    return (InvoicePrinter) printers.get(printerName);
  }

  public static String[] getPrinterNames() {
    Set keys = printers.keySet();
    String[] printerNames = new String[keys.size()];
    Iterator keyIterator = keys.iterator();
    int index = 0;
    while (keyIterator.hasNext()) {
      printerNames[index++] = (String) keyIterator.next();
    }
    return printerNames;
  }

  private static HashMap printers = new HashMap();

  public abstract void printTo(Invoice theInvoiceToPrint, Writer writer);

  protected String lineOrEmpty(StringTokenizer tokens) {
    return tokens.hasMoreTokens() ? tokens.nextToken() : "";
  }

  protected void printHeader(Writer writer, Company company, Invoice invoice)
    throws IOException {
    writer.write(
      MessageFormat.format(
        "<html><head><title>Invoice #{0,number,integer}</title></head>\n<body>\n",
        new Object[] { new Integer(invoice.getNumber())}));

    writer.write(
      MessageFormat.format(
        "<center><img src=\"{0}\"></center></br>\n",
        new Object[] { company.getLogo()}));
    writer.write(
      MessageFormat.format("<b>{0}</b><br>\n", new Object[] { company.getName()}));
    writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">\n");
    StringTokenizer addressLines =
      new StringTokenizer(company.getAddress(), "\n\r");
    writer.write(
      MessageFormat.format(
        "<tr><td>{0}</td><td>Invoice #{1,number,integer}</td></tr>\n",
        new Object[] { lineOrEmpty(addressLines), new Integer(invoice.getNumber())}));
    writer.write(
      MessageFormat.format(
        "<tr><td>{0}</td><td>Invoice Date: {1,date}</td></tr>\n",
        new Object[] { lineOrEmpty(addressLines), invoice.getDate()}));
    writer.write(
      MessageFormat.format(
        "<tr><td>{0}</td><td>HST# {1}</td></tr>\n",
        new Object[] { lineOrEmpty(addressLines), company.getHst()}));
    writer.write("</table>\n");
    writer.write("<p>\n<table cellpadding=\"0\" cellspacing=\"0\">\n");
    writer.write("\t<tr>");
    writer.write("<td valign=\"top\">Client:</td>");
    writer.write("<td valign=\"top\"><table cellpadding=\"0\" cellspacing=\"0\">\n");
    writer.write(
      MessageFormat.format(
        "\t\t<tr><td>{0}</td></tr>\n",
        new Object[] { invoice.getCustomer().getName()}));
    StringTokenizer customerAddressLines =
      new StringTokenizer(invoice.getCustomer().getAddress());
    MessageFormat addressFormatter =
      new MessageFormat("\t\t<tr><td>{0}</td></tr>\n");
    while (customerAddressLines.hasMoreTokens()) {
      writer.write(
        addressFormatter.format(new Object[] { customerAddressLines.nextToken()}));
    }
    writer.write("</table></td></tr></table>");
    writer.write(
      MessageFormat.format(
        "<p>Job: {0}\n",
        new Object[] { invoice.getDescription()}));
  }

  protected void printFooter(Writer writer) throws IOException {
    writer.write("</body></html>");
  }

}