// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm;

import java.math.BigDecimal;

/**
 * This class represents one line on a quote/invoice that relates to
 * an item required/used.
 */

public class Lineitem {
  public static Lineitem makeEmptyLineitem() {
    return new Lineitem(Part.nullPart, 0);
  }

  public Lineitem(Part aPart, int qty) {
    part = aPart;
    quantity = qty;
  }

  public Part getPart() {
    return part;
  }

  public String getDescription() {
    return part.getName();
  }

  public void addToQuantity(int changeInQuantity) {
    quantity += changeInQuantity;
    tracker.set();
  }

  public void setQuantity(int newQuantity) {
    quantity = newQuantity;
    tracker.set();
  }

  public int getQuantity() {
    return quantity;
  }

  public BigDecimal getUnitPrice() {
    return part.getPrice();
  }

  public BigDecimal calcExtendedPrice() {
    return part.costForThisMany(quantity);
  }

  Part part = null;
  int quantity = 0;
  ChangeTracker tracker = ChangeTracker.getTracker("lineitem");
}